/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import org.apache.commons.lang.NotImplementedException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.util.journal.queue.LocalTxQueueTransactionRecoverer;
import org.mule.util.queue.DefaultQueueConfiguration;
import org.mule.util.queue.DefaultQueueStore;
import org.mule.util.queue.PersistentQueueTransactionContext;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueProvider;
import org.mule.util.queue.QueueStore;
import org.mule.util.queue.RecoverableQueueStore;
import org.mule.util.queue.TestTransactionLogger;
import org.mule.util.xa.ResourceManagerException;

public class LocalTxQueueTransactionRecovererTestCase
extends AbstractMuleContextTestCase {
    public static final String QUEUE_NAME = "inQueue";
    public static final String MESSAGE_CONTENT = "data";
    private static final int TIMEOUT = 10;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private LocalTxQueueTransactionJournal txLog;
    private DefaultQueueStore inQueue;
    private PersistentQueueTransactionContext persistentTransactionContext;
    private LocalTxQueueTransactionRecoverer queueTransactionRecoverer;

    @Override
    protected void doSetUp() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setWorkingDirectory(this.temporaryFolder.getRoot().getAbsolutePath());
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.inQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        this.persistentTransactionContext = new PersistentQueueTransactionContext(this.txLog, this.createQueueProvider(this.inQueue));
        this.queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(this.txLog, this.createQueueProvider(this.inQueue));
    }

    @Override
    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        DefaultMuleConfiguration muleConfiguration = new DefaultMuleConfiguration();
        muleConfiguration.setWorkingDirectory(this.temporaryFolder.getRoot().getAbsolutePath());
        contextBuilder.setMuleConfiguration((MuleConfiguration)muleConfiguration);
    }

    @Test
    public void pollAndFailThenRecover() throws Exception {
        MuleEvent testEvent = LocalTxQueueTransactionRecovererTestCase.getTestEvent(MESSAGE_CONTENT);
        this.inQueue.offer((Serializable)testEvent, 0, 10L);
        Serializable value = this.persistentTransactionContext.poll((QueueStore)this.inQueue, 100000L);
        Assert.assertThat((Object)this.inQueue.poll(10L), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)value, (Matcher)IsNull.notNullValue());
        this.txLog.close();
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer.recover();
        Serializable muleEvent = this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)testEvent.equals(muleEvent), (Matcher)Is.is((Object)true));
    }

    @Test
    public void pollAndFailThenRecoverWithTwoElements() throws Exception {
        String MESSAGE_CONTENT_2 = "data2";
        MuleEvent testEvent = LocalTxQueueTransactionRecovererTestCase.getTestEvent(MESSAGE_CONTENT);
        MuleEvent testEvent2 = LocalTxQueueTransactionRecovererTestCase.getTestEvent("data2");
        this.inQueue.offer((Serializable)testEvent, 0, 10L);
        this.inQueue.offer((Serializable)testEvent2, 0, 10L);
        Serializable value = this.persistentTransactionContext.poll((QueueStore)this.inQueue, 100000L);
        Assert.assertThat((Object)this.inQueue.getSize(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)value, (Matcher)IsNull.notNullValue());
        this.txLog.close();
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer.recover();
        MuleEvent muleEvent = (MuleEvent)this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)muleEvent.getMessage().getPayload().toString(), (Matcher)Is.is((Object)"data2"));
        muleEvent = (MuleEvent)this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)muleEvent.getMessage().getPayload().toString(), (Matcher)Is.is((Object)MESSAGE_CONTENT));
    }

    @Test
    public void failBetweenLogEntryWriteAndRealPoolThenRecover() throws Exception {
        MuleEvent testEvent = LocalTxQueueTransactionRecovererTestCase.getTestEvent(MESSAGE_CONTENT);
        this.inQueue.offer((Serializable)testEvent, 0, 10L);
        this.persistentTransactionContext.poll((QueueStore)this.inQueue, 10L);
        this.txLog.close();
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer.recover();
        Serializable muleEvent = this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)testEvent.equals(muleEvent), (Matcher)Is.is((Object)true));
        muleEvent = this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.nullValue());
    }

    private QueueProvider createQueueProvider(final DefaultQueueStore queue) {
        return new QueueProvider(){

            public QueueStore getQueue(String queueName) {
                throw new NotImplementedException();
            }

            public RecoverableQueueStore getRecoveryQueue(String queueName) {
                return queue;
            }
        };
    }

    @Test
    public void offerAndFailThenRecover() throws Exception {
        DefaultQueueStore outQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        this.persistentTransactionContext = new PersistentQueueTransactionContext(this.txLog, this.createQueueProvider(outQueue));
        MuleEvent testEvent = LocalTxQueueTransactionRecovererTestCase.getTestEvent(MESSAGE_CONTENT);
        this.persistentTransactionContext.offer((QueueStore)outQueue, (Serializable)testEvent, 10L);
        Assert.assertThat((Object)outQueue.poll(10L), (Matcher)IsNull.nullValue());
        this.txLog.close();
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(this.txLog, this.createQueueProvider(outQueue));
        this.queueTransactionRecoverer.recover();
        Serializable muleEvent = outQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.nullValue());
    }

    @Test
    public void offerAndFailBetweenRealOfferAndCommitThenRecover() throws Exception {
        this.txLog = new TestTransactionLogger(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext).failDuringLogCommit();
        DefaultQueueStore outQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        this.persistentTransactionContext = new PersistentQueueTransactionContext(this.txLog, this.createQueueProvider(outQueue));
        MuleEvent testEvent = LocalTxQueueTransactionRecovererTestCase.getTestEvent(MESSAGE_CONTENT);
        this.persistentTransactionContext.offer((QueueStore)outQueue, (Serializable)testEvent, 10L);
        try {
            this.persistentTransactionContext.doCommit();
            Assert.fail();
        }
        catch (ResourceManagerException e) {
            // empty catch block
        }
        this.txLog.close();
        this.txLog = new TestTransactionLogger(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(this.txLog, this.createQueueProvider(outQueue));
        this.queueTransactionRecoverer.recover();
        Serializable muleEvent = outQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.nullValue());
    }
}

