/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.IOException;
import java.util.List;
import javax.activation.DataHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.expression.RequiredValueException;
import org.mule.expression.AbstractAttachmentsTestCase;
import org.mule.expression.MessageAttachmentsListExpressionEvaluator;
import org.mule.util.ArrayUtils;

public class MessageAttachmentsListExpressionEvaluatorTestCase
extends AbstractAttachmentsTestCase {
    private MessageAttachmentsListExpressionEvaluator evaluator = new MessageAttachmentsListExpressionEvaluator();

    @Test
    public void requiredKeysWithExistingAttachmentsShouldReturnAttachments() throws Exception {
        Object result = this.evaluator.evaluate("foo, baz", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        this.assertAttachmentAtIndexHasValue(0, "foovalue", list);
        this.assertAttachmentAtIndexHasValue(1, "bazvalue", list);
    }

    @Test
    public void requiredKeysWithExistingAttachmentsViaExpressionManagerShouldReturnAttachments() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:foo, baz]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        this.assertAttachmentAtIndexHasValue(0, "foovalue", list);
        this.assertAttachmentAtIndexHasValue(1, "bazvalue", list);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredKeysWithMissingAttachmentsShouldFail() throws Exception {
        this.evaluator.evaluate("nonexistent", this.message);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredKeysWithMissingAttachmentsViaExpressionManagerShouldFail() throws Exception {
        muleContext.getExpressionManager().evaluate("#[attachments-list:nonexistent]", this.message);
    }

    @Test
    public void optionalKeysWithExistingAttachmentsShouldReturnAttachments() throws Exception {
        Object result = this.evaluator.evaluate("foo?, bar?", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        this.assertAttachmentAtIndexHasValue(0, "foovalue", list);
        this.assertAttachmentAtIndexHasValue(1, "barvalue", list);
    }

    @Test
    public void optionalKeysWithExistingAttachmentsViaExpressionManagerShouldReturnAttachments() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:foo?, bar?]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        this.assertAttachmentAtIndexHasValue(0, "foovalue", list);
        this.assertAttachmentAtIndexHasValue(1, "barvalue", list);
    }

    @Test
    public void optionalKeysWithMissingAttachmentsShouldReturnEmptyList() throws Exception {
        Object result = this.evaluator.evaluate("nonexistent?", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void optionalKeysWithMissingAttachmentsViaExpressionManagerShouldReturnEmptyList() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:nonexistent?]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void matchAllWildcardShouldReturnAllAttachments() throws Exception {
        Object result = this.evaluator.evaluate("*", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)3L, (long)list.size());
        this.assertAttachmentsContain(list, "foovalue", "bazvalue", "barvalue");
    }

    @Test
    public void matchAllWildcardViaExpressionManagerShouldReturnAllAttachments() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:*]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)3L, (long)list.size());
        this.assertAttachmentsContain(list, "foovalue", "bazvalue", "barvalue");
    }

    @Test
    public void matchBeginningWildcardShouldReturnAttachments() throws Exception {
        Object result = this.evaluator.evaluate("ba*", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        this.assertAttachmentsContain(list, "bazvalue", "barvalue");
    }

    @Test
    public void matchBeginningWildcardViaExpressionManagerShouldReturnAttachments() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:ba*]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        this.assertAttachmentsContain(list, "bazvalue", "barvalue");
    }

    @Test
    public void wildcardWithNoMatchShouldReturnEmptyList() {
        Object result = this.evaluator.evaluate("x*", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void wildcardWithNoMatchViaExpressionManagerShouldReturnEmptyList() {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:x*]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void multipleWildcardsShouldReturnValues() throws Exception {
        Object result = this.evaluator.evaluate("ba*, f*", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)3L, (long)list.size());
        this.assertAttachmentsContain(list, "foovalue", "bazvalue", "barvalue");
    }

    @Test
    public void multipleWildcardsViaExpressionManagerShouldReturnValues() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:ba*, f*]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)3L, (long)list.size());
        this.assertAttachmentsContain(list, "foovalue", "bazvalue", "barvalue");
    }

    private void assertAttachmentAtIndexHasValue(int index, String expectedValue, List<?> list) throws IOException {
        Object attachment = list.get(index);
        Assert.assertNotNull(attachment);
        this.assertAttachmentValueEquals(expectedValue, attachment);
    }

    private void assertAttachmentsContain(List<?> list, String ... expected) throws IOException {
        for (Object object : list) {
            String attachmentString = this.attachmentToString((DataHandler)object);
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])expected, (Object)attachmentString));
        }
    }
}

