/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.el.context.AbstractELTestCase;
import org.mule.el.mvel.MVELExpressionExecutor;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.tck.size.SmallTest;
import org.objectweb.asm.ClassWriter;

@SmallTest
public class MVELExpressionExecutorTestCase
extends AbstractELTestCase {
    protected MVELExpressionExecutor mvel;
    protected MVELExpressionLanguageContext context;

    public MVELExpressionExecutorTestCase(AbstractELTestCase.Variant variant, String mvelOptimizer) {
        super(variant, mvelOptimizer);
    }

    @Before
    public void setupMVEL() throws InitialisationException {
        this.mvel = new MVELExpressionExecutor(new ParserConfiguration());
        this.context = (MVELExpressionLanguageContext)Mockito.mock(MVELExpressionLanguageContext.class);
        Mockito.when((Object)this.context.isResolveable(Mockito.anyString())).thenReturn((Object)false);
    }

    @Test
    public void evaluateReturnInt() {
        Assert.assertEquals((Object)4, (Object)this.mvel.execute("2*2", null));
    }

    @Test
    public void evaluateReturnString() {
        Assert.assertEquals((Object)"hi", (Object)this.mvel.execute("'hi'", null));
    }

    @Test(expected=CompileException.class)
    public void evaluateInvalidExpression() {
        Assert.assertEquals((Object)4, (Object)this.mvel.execute("2*'2", null));
    }

    @Test(expected=CompileException.class)
    public void invalidExpression() {
        this.mvel.validate("a9-#'");
    }

    @Test
    public void validExpression() {
        this.mvel.validate("var a = 2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useContextClassLoader() throws ClassNotFoundException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new MyClassClassLoader());
            Assert.assertFalse((boolean)((Boolean)this.mvel.execute("1 is org.MyClass", null)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Test
    public void safeMapPropertyAccessIsEnabled() {
        Assert.assertEquals(null, (Object)this.mvel.execute("['test1' : null].doesntExist", this.context));
    }

    @Test
    public void safeMapNestedPropertyAccessIsEnabled() {
        Assert.assertEquals(null, (Object)this.mvel.execute("['test1' : null].test1", this.context));
    }

    @Test
    public void safeBeanPropertyAccessIsEnabled() {
        Assert.assertNull((Object)this.mvel.execute("new Object().doesntExist", this.context));
    }

    @Test
    public void safeNestedBeanPropertyAccessIsEnabled() {
        Assert.assertNull((Object)this.mvel.execute("new Object().?doesntExist.other", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void nestedMapAccessFailsCorrectly() {
        Assert.assertNull((Object)this.mvel.execute("['test1' : null]['test2']['test2']", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void safeNestedBeanPropertyAccessMaintainsNullSafeBehavior() {
        Assert.assertNull((Object)this.mvel.execute("new Object().doesntExist.other", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void safeNestedMapPropertyAccessMaintainsNullSafeBehavior() {
        Assert.assertNull((Object)this.mvel.execute("['test1' : null].doesntExist.other", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void safePropertyDoesntMessNullSafeMode() {
        Assert.assertNull((Object)this.mvel.execute("null.doesntExist", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void invalidMethodCallFails() {
        Assert.assertNull((Object)this.mvel.execute("new Object().doesntExist()", this.context));
    }

    static class MyClassClassLoader
    extends ClassLoader {
        MyClassClassLoader() {
        }

        @Override
        protected Class<?> findClass(String className) throws ClassNotFoundException {
            if (className.equals("org.MyClass")) {
                ClassWriter cw = new ClassWriter(2);
                cw.visit(49, 1, "org/MyClass", null, "java/lang/Object", null);
                return this.defineClass(className, cw.toByteArray(), 0, cw.toByteArray().length);
            }
            return super.findClass(className);
        }
    }
}

