/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.bootstrap;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.bootstrap.RegistryBootstrapDiscoverer;
import org.mule.config.bootstrap.SimpleRegistryBootstrap;
import org.mule.config.bootstrap.SinglePropertiesRegistryBootstrapDiscoverer;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.AbstractDiscoverableTransformer;

public class SimpleRegistryBootstrapTransformersTest
extends AbstractMuleContextTestCase {
    @Test
    public void registeringTransformersWithCustomKey() throws MuleException {
        Properties properties = new Properties();
        properties.setProperty("core.transformer.1", ExpectedKeyTransformer.class.getName());
        properties.setProperty("custom1", CustomKeyTransformer.class.getName());
        TestTransformerResolver transformerResolver = new TestTransformerResolver();
        muleContext.getRegistry().registerObject("testTransformerResolver", (Object)transformerResolver);
        SimpleRegistryBootstrap registryBootstrap = new SimpleRegistryBootstrap((RegistryBootstrapDiscoverer)new SinglePropertiesRegistryBootstrapDiscoverer(properties));
        registryBootstrap.setMuleContext(muleContext);
        registryBootstrap.initialise();
        junit.framework.Assert.assertEquals((int)2, (int)transformerResolver.getTransformersCount());
        Assert.assertTrue((boolean)transformerResolver.contains(ExpectedKeyTransformer.class));
        Assert.assertTrue((boolean)transformerResolver.contains(CustomKeyTransformer.class));
    }

    @Override
    protected ConfigurationBuilder getBuilder() throws Exception {
        return new DummyConfigurationBuilder();
    }

    private static class TestTransformerResolver
    implements TransformerResolver {
        private List<Transformer> transformers = new ArrayList<Transformer>();

        private TestTransformerResolver() {
        }

        public Transformer resolve(DataType<?> source, DataType<?> result) throws ResolverException {
            return null;
        }

        public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
            this.transformers.add(transformer);
        }

        public int getTransformersCount() {
            return this.transformers.size();
        }

        private boolean contains(Class<? extends Transformer> transformerClass) {
            for (Transformer transformer : this.transformers) {
                if (!transformerClass.isAssignableFrom(transformer.getClass())) continue;
                return true;
            }
            return false;
        }
    }

    public static class CustomKeyTransformer
    extends AbstractDiscoverableTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            return null;
        }
    }

    public static class ExpectedKeyTransformer
    extends AbstractDiscoverableTransformer {
        protected Object doTransform(Object src, String enc) throws TransformerException {
            return null;
        }
    }

    private class DummyConfigurationBuilder
    extends DefaultsConfigurationBuilder {
        private DummyConfigurationBuilder() {
        }

        protected void doConfigure(MuleContext muleContext) throws Exception {
        }
    }
}

