/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.util.FileUtils;
import org.mule.util.queue.RawDataSelector;

class RandomAccessFileQueueStore {
    private final Log logger = LogFactory.getLog(this.getClass());
    protected static final int CONTROL_DATA_SIZE = 5;
    private static final byte NOT_REMOVED = 0;
    private static final byte REMOVED = 1;
    private final File file;
    private RandomAccessFile queueFile;
    private LinkedList<Long> orderedKeys = new LinkedList();
    private long fileTotalSpace = 0L;

    public RandomAccessFileQueueStore(File file) {
        this.file = file;
        this.createQueueFile();
        this.initialise();
    }

    public synchronized void addLast(byte[] element) {
        long filePointer = this.writeData(element);
        this.orderedKeys.addLast(filePointer);
    }

    public synchronized byte[] removeFirst() throws InterruptedException {
        try {
            if (this.orderedKeys.isEmpty()) {
                return null;
            }
            Long filePosition = this.orderedKeys.getFirst();
            this.queueFile.seek(filePosition);
            this.queueFile.writeByte(1);
            byte[] data = this.readDataInCurrentPosition();
            this.orderedKeys.removeFirst();
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized byte[] getFirst() throws InterruptedException {
        return this.readFirstValue();
    }

    public synchronized void addFirst(byte[] item) throws InterruptedException {
        this.orderedKeys.addFirst(this.writeData(item));
    }

    public int getSize() {
        return this.orderedKeys.size();
    }

    public synchronized void clear() {
        try {
            this.queueFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.orderedKeys.clear();
        this.fileTotalSpace = 0L;
        FileUtils.deleteQuietly((File)this.file);
        this.createQueueFile();
    }

    public synchronized boolean addAll(Collection<? extends byte[]> items) {
        for (byte[] byArray : items) {
            this.addLast(byArray);
        }
        return true;
    }

    public synchronized Collection<byte[]> allElements() {
        LinkedList<byte[]> elements = new LinkedList<byte[]>();
        try {
            this.queueFile.seek(0L);
            while (true) {
                boolean removed;
                if (!(removed = this.queueFile.readBoolean())) {
                    elements.add(this.readDataInCurrentPosition());
                    continue;
                }
                this.moveFilePointerToNextData();
            }
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            return elements;
        }
    }

    public boolean isEmpty() {
        return this.orderedKeys.isEmpty();
    }

    public synchronized boolean remove(RawDataSelector rawDataSelector) {
        try {
            long currentPosition;
            byte[] data;
            byte removed;
            this.queueFile.seek(0L);
            do {
                currentPosition = this.queueFile.getFilePointer();
            } while ((removed = this.queueFile.readByte()) != 0 || !rawDataSelector.isSelectedData(data = this.readDataInCurrentPosition()));
            this.queueFile.seek(currentPosition);
            this.queueFile.writeByte(1);
            this.orderedKeys.remove(currentPosition);
            return true;
        }
        catch (EOFException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close() {
        block2: {
            try {
                this.queueFile.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)e.getMessage());
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)e);
            }
        }
    }

    private byte[] readDataInCurrentPosition() throws IOException {
        int serializedValueSize = this.queueFile.readInt();
        byte[] data = new byte[serializedValueSize];
        this.queueFile.read(data, 0, serializedValueSize);
        return data;
    }

    private void createQueueFile() {
        try {
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    throw new MuleRuntimeException(e);
                }
            }
            this.queueFile = new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private long writeData(byte[] data) {
        try {
            if (this.getSize() > 0) {
                this.queueFile.seek(this.fileTotalSpace);
            }
            long filePointer = this.queueFile.getFilePointer();
            int totalBytesRequired = 5 + data.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(totalBytesRequired);
            byteBuffer.put((byte)0);
            byteBuffer.putInt(data.length);
            byteBuffer.put(data);
            this.queueFile.write(byteBuffer.array());
            this.fileTotalSpace += (long)totalBytesRequired;
            return filePointer;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private void initialise() {
        try {
            this.queueFile.seek(0L);
            while (true) {
                long position = this.queueFile.getFilePointer();
                byte removed = this.queueFile.readByte();
                if (removed == 0) {
                    this.orderedKeys.add(position);
                    this.moveFilePointerToNextData();
                    continue;
                }
                this.moveFilePointerToNextData();
            }
        }
        catch (EOFException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            throw new MuleRuntimeException(e);
        }
    }

    private byte[] readFirstValue() {
        try {
            if (this.orderedKeys.isEmpty()) {
                return null;
            }
            Long filePointer = this.orderedKeys.getFirst();
            this.queueFile.seek(filePointer);
            this.queueFile.readByte();
            return this.readDataInCurrentPosition();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private void moveFilePointerToNextData() throws IOException {
        int serializedValueSize = this.queueFile.readInt();
        this.queueFile.seek(this.queueFile.getFilePointer() + (long)serializedValueSize);
    }

    public long getLength() {
        return this.fileTotalSpace;
    }

    public synchronized boolean contains(RawDataSelector rawDataSelector) {
        try {
            this.queueFile.seek(0L);
            while (true) {
                byte removed;
                if ((removed = this.queueFile.readByte()) == 0) {
                    byte[] data = this.readDataInCurrentPosition();
                    if (!rawDataSelector.isSelectedData(data)) continue;
                    return true;
                }
                this.moveFilePointerToNextData();
            }
        }
        catch (EOFException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

