/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.util.Preconditions;
import org.mule.util.SerializationUtils;
import org.mule.util.queue.AbstractQueueStoreDelegate;
import org.mule.util.queue.RandomAccessFileQueueStore;
import org.mule.util.queue.RawDataSelector;
import org.mule.util.queue.TransactionalQueueStoreDelegate;

public class DualRandomAccessFileQueueStoreDelegate
extends AbstractQueueStoreDelegate
implements TransactionalQueueStoreDelegate {
    private static final String QUEUE_STORE_DIRECTORY = "queuestore";
    public static final int ONE_MEGABYTE = 0x100000;
    private static final Integer MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES = Integer.valueOf(System.getProperty("mule.queue.maxlength", Integer.valueOf(0x100000).toString()));
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final MuleContext muleContext;
    private final ReadWriteLock filesLock;
    private RandomAccessFileQueueStore writeFile;
    private RandomAccessFileQueueStore readFile;
    private RandomAccessFileQueueStore randomAccessFileQueueStore1;
    private RandomAccessFileQueueStore randomAccessFileQueueStore2;

    public DualRandomAccessFileQueueStoreDelegate(String queueName, String workingDirectory, MuleContext muleContext, int capacity) {
        super(capacity);
        this.muleContext = muleContext;
        File queuesDirectory = new File(workingDirectory + File.separator + QUEUE_STORE_DIRECTORY);
        if (!queuesDirectory.exists()) {
            Preconditions.checkState(queuesDirectory.mkdirs(), "Could not create queue store directory " + queuesDirectory.getAbsolutePath());
        }
        File queueStoreFile1 = DualRandomAccessFileQueueStoreDelegate.getFirstQueueFile(queueName, workingDirectory);
        File queueStoreFile2 = DualRandomAccessFileQueueStoreDelegate.getSecondQueueFile(queueName, workingDirectory);
        this.randomAccessFileQueueStore1 = new RandomAccessFileQueueStore(queueStoreFile1);
        this.randomAccessFileQueueStore2 = new RandomAccessFileQueueStore(queueStoreFile2);
        this.writeFile = this.randomAccessFileQueueStore1;
        this.readFile = this.randomAccessFileQueueStore1;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Queue %s has %s messages", queueName, this.getSize()));
        }
        this.filesLock = new ReentrantReadWriteLock();
    }

    public static File getFirstQueueFile(String queueName, String workingDirectory) {
        return DualRandomAccessFileQueueStoreDelegate.getQueueFile(queueName, workingDirectory, "-1");
    }

    public static File getSecondQueueFile(String queueName, String workingDirectory) {
        return DualRandomAccessFileQueueStoreDelegate.getQueueFile(queueName, workingDirectory, "-2");
    }

    private static File getQueueFile(String queueName, String workingDirectory, String suffix) {
        return new File(new File(workingDirectory + File.separator + QUEUE_STORE_DIRECTORY), queueName + suffix);
    }

    @Override
    protected void addFirst(Serializable item) throws InterruptedException {
        this.switchWriteFileIfFull();
        byte[] serialiazedObject = SerializationUtils.serialize((Serializable)item);
        this.readFile.addFirst(serialiazedObject);
    }

    @Override
    protected void add(Serializable item) {
        this.switchWriteFileIfFull();
        byte[] serialiazedObject = SerializationUtils.serialize((Serializable)item);
        this.writeFile.addLast(serialiazedObject);
    }

    @Override
    protected Serializable removeFirst() throws InterruptedException {
        Serializable value = this.getFirst();
        if (value != null) {
            this.readFile.removeFirst();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Serializable getFirst() throws InterruptedException {
        byte[] bytes;
        if (this.isEmpty()) {
            return null;
        }
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            if (this.readFile.isEmpty()) {
                this.readFile.clear();
                this.switchReadFile();
            }
            bytes = this.readFile.getFirst();
        }
        finally {
            lock.unlock();
        }
        return this.deserialize(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            int n = this.randomAccessFileQueueStore1.getSize() + this.randomAccessFileQueueStore2.getSize();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isEmpty() {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            boolean bl = this.randomAccessFileQueueStore1.isEmpty() && this.randomAccessFileQueueStore2.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void doClear() {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            this.randomAccessFileQueueStore1.clear();
            this.randomAccessFileQueueStore2.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doAddAll(Collection<? extends Serializable> items) {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            for (Serializable serializable : items) {
                this.add(serializable);
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    public Collection<Serializable> allElements() {
        LinkedList<Serializable> elements = new LinkedList<Serializable>();
        elements.addAll(this.deserializeValues(this.randomAccessFileQueueStore1.allElements()));
        elements.addAll(this.deserializeValues(this.randomAccessFileQueueStore2.allElements()));
        return elements;
    }

    private Collection<Serializable> deserializeValues(Collection<byte[]> valuesAsBytes) {
        ArrayList<Serializable> values = new ArrayList<Serializable>(valuesAsBytes.size());
        for (byte[] valueAsByte : valuesAsBytes) {
            try {
                values.add(this.deserialize(valueAsByte));
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failure trying to deserialize value " + e.getMessage()));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)e);
            }
        }
        return values;
    }

    private Serializable deserialize(byte[] valuesAsBytes) {
        return (Serializable)SerializationUtils.deserialize(valuesAsBytes, this.muleContext);
    }

    @Override
    public void remove(Serializable value) {
        RawDataSelector rawDataSelector = this.createDataSelector(value);
        if (!this.randomAccessFileQueueStore1.remove(rawDataSelector)) {
            this.randomAccessFileQueueStore2.remove(rawDataSelector);
        }
    }

    private RawDataSelector createDataSelector(final Serializable value) {
        return new RawDataSelector(){

            @Override
            public boolean isSelectedData(byte[] data) {
                return DualRandomAccessFileQueueStoreDelegate.this.deserialize(data).equals(value);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Serializable value) {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            RawDataSelector dataSelector = this.createDataSelector(value);
            if (!this.randomAccessFileQueueStore1.contains(dataSelector)) {
                boolean bl = this.randomAccessFileQueueStore2.contains(dataSelector);
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            this.randomAccessFileQueueStore1.close();
            this.randomAccessFileQueueStore2.close();
        }
        finally {
            lock.unlock();
        }
    }

    private void switchReadFile() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("switching read file. Random 1 size: " + this.randomAccessFileQueueStore1.getSize() + " , Random 2 size: " + this.randomAccessFileQueueStore2.getSize()));
        }
        this.readFile = this.nextReadFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchWriteFileIfFull() {
        if (this.writeFile.getLength() >= (long)MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES.intValue()) {
            Lock lock = this.filesLock.writeLock();
            lock.lock();
            try {
                if (this.writeFile.getLength() >= (long)MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES.intValue()) {
                    if (this.randomAccessFileQueueStore1.getLength() >= (long)MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES.intValue() && this.randomAccessFileQueueStore2.getLength() >= (long)MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES.intValue()) {
                        return;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("switching write file. Random 1 size: " + this.randomAccessFileQueueStore1.getLength() + " , Random 2 size: " + this.randomAccessFileQueueStore2.getLength()));
                    }
                    this.writeFile = this.writeFile == this.randomAccessFileQueueStore1 ? this.randomAccessFileQueueStore2 : this.randomAccessFileQueueStore1;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private RandomAccessFileQueueStore nextReadFile() {
        return this.readFile == this.randomAccessFileQueueStore1 ? this.randomAccessFileQueueStore2 : this.randomAccessFileQueueStore1;
    }

    @Override
    public void dispose() {
        this.doClear();
    }
}

