/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.text.MessageFormat;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.TransactionNotification;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;
import org.mule.util.UUID;

public abstract class AbstractTransaction
implements org.mule.api.transaction.Transaction {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected String id = UUID.getUUID();
    protected MuleContext muleContext;

    protected AbstractTransaction(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public boolean isRollbackOnly() throws TransactionException {
        int status = this.getStatus();
        return status == 1 || status == 4 || status == 9;
    }

    @Override
    public boolean isBegun() throws TransactionException {
        int status = this.getStatus();
        return status != 6 && status != 5;
    }

    @Override
    public boolean isRolledBack() throws TransactionException {
        return this.getStatus() == 4;
    }

    @Override
    public boolean isCommitted() throws TransactionException {
        return this.getStatus() == 3;
    }

    @Override
    public void begin() throws TransactionException {
        this.logger.debug((Object)"Beginning transaction");
        this.doBegin();
        TransactionCoordination.getInstance().bindTransaction(this);
        this.fireNotification(new TransactionNotification(this, 1201));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws TransactionException {
        try {
            this.logger.debug((Object)("Committing transaction " + this));
            if (this.isRollbackOnly()) {
                throw new IllegalTransactionStateException(CoreMessages.transactionMarkedForRollback());
            }
            this.doCommit();
            this.fireNotification(new TransactionNotification(this, 1202));
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws TransactionException {
        try {
            this.logger.debug((Object)"Rolling back transaction");
            this.setRollbackOnly();
            this.doRollback();
            this.fireNotification(new TransactionNotification(this, 1203));
        }
        finally {
            this.unbindTransaction();
        }
    }

    protected void unbindTransaction() throws TransactionException {
        TransactionCoordination.getInstance().unbindTransaction(this);
    }

    protected abstract void doBegin() throws TransactionException;

    protected abstract void doCommit() throws TransactionException;

    protected abstract void doRollback() throws TransactionException;

    protected void fireNotification(TransactionNotification notification) {
        this.muleContext.fireNotification(notification);
    }

    @Override
    public boolean isXA() {
        return false;
    }

    @Override
    public void resume() throws TransactionException {
        throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction(this));
    }

    @Override
    public Transaction suspend() throws TransactionException {
        throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction(this));
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        int status;
        try {
            status = this.getStatus();
        }
        catch (TransactionException e) {
            status = -1;
        }
        return MessageFormat.format("{0}[id={1} , status={2}]", this.getClass().getName(), this.id, status);
    }
}

