/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.transport.PropertyScope;

public class OutboundHeadersExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "outboundHeaders";
    protected final transient Log logger = LogFactory.getLog(OutboundHeadersExpressionEvaluator.class);

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        if (message == null) {
            return null;
        }
        return new SendHeadersMap(message);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("name");
    }

    public static class SendHeadersMap
    implements Map<String, Object> {
        private MuleMessage message;

        public SendHeadersMap(MuleMessage message) {
            this.message = message;
        }

        @Override
        public int size() {
            return this.message.getOutboundPropertyNames().size();
        }

        @Override
        public boolean isEmpty() {
            return this.message.getOutboundPropertyNames().size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.message.getOutboundPropertyNames().contains(key.toString());
        }

        @Override
        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        public Object get(Object key) {
            return this.message.getOutboundProperty(key.toString());
        }

        @Override
        public Object put(String key, Object value) {
            this.message.setOutboundProperty(key, value);
            return value;
        }

        @Override
        public Object remove(Object key) {
            return this.message.removeProperty(key.toString(), PropertyScope.OUTBOUND);
        }

        @Override
        public void putAll(Map<? extends String, ?> t) {
            for (Map.Entry<String, ?> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.message.clearProperties(PropertyScope.OUTBOUND);
        }

        @Override
        public Set<String> keySet() {
            return this.message.getOutboundPropertyNames();
        }

        @Override
        public Collection<Object> values() {
            return this.getPropertiesInScope(PropertyScope.OUTBOUND).values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.getPropertiesInScope(PropertyScope.OUTBOUND).entrySet();
        }

        private Map<String, Object> getPropertiesInScope(PropertyScope scope) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String s : this.message.getPropertyNames(scope)) {
                props.put(s, this.message.getProperty(s, scope));
            }
            return props;
        }
    }
}

