/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.mule.el.datetime.DateTime;

public class ServerContext {
    public String getHost() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public String getIp() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public TimeZone getTimeZone() {
        return Calendar.getInstance().getTimeZone();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public Map<String, String> getEnv() {
        return System.getenv();
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public String getOsName() {
        return System.getProperty("os.name");
    }

    public String getOsArch() {
        return System.getProperty("os.arch");
    }

    public String getOsVersion() {
        return System.getProperty("os.version");
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public String getUserHome() {
        return System.getProperty("user.home");
    }

    public String getUserDir() {
        return System.getProperty("user.dir");
    }

    public DateTime getDateTime() {
        return new DateTime();
    }

    public long nanoTime() {
        return System.nanoTime();
    }
}

