/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.routing;

import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.mule.VoidMuleEvent;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.util.Preconditions;

public final class AggregationContext {
    private static final Predicate failedEventsPredicate = new Predicate(){

        public boolean evaluate(Object object) {
            if (VoidMuleEvent.getInstance().equals(object)) {
                return false;
            }
            MuleEvent event = (MuleEvent)object;
            ExceptionPayload ep = event.getMessage().getExceptionPayload();
            return ep != null && ep.getException() != null;
        }
    };
    private final MuleEvent originalEvent;
    private final List<MuleEvent> events;

    public AggregationContext(MuleEvent originalEvent, List<MuleEvent> events) {
        Preconditions.checkArgument(events != null, "events cannot be null");
        this.originalEvent = originalEvent;
        this.events = Collections.unmodifiableList(events);
    }

    public List<MuleEvent> collectEventsWithExceptions() {
        return (List)CollectionUtils.select(this.events, (Predicate)failedEventsPredicate);
    }

    public NavigableMap<Integer, Throwable> collectRouteExceptions() {
        TreeMap<Integer, Throwable> routes = new TreeMap<Integer, Throwable>();
        for (int i = 0; i < this.events.size(); ++i) {
            MuleEvent event = this.events.get(i);
            if (!failedEventsPredicate.evaluate((Object)event)) continue;
            routes.put(i, event.getMessage().getExceptionPayload().getException());
        }
        return routes;
    }

    public List<MuleEvent> collectEventsWithoutExceptions() {
        return (List)CollectionUtils.selectRejected(this.events, (Predicate)failedEventsPredicate);
    }

    public MuleEvent getOriginalEvent() {
        return this.originalEvent;
    }

    public List<MuleEvent> getEvents() {
        return this.events;
    }
}

