/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.CopyOnWriteCaseInsensitiveMap;
import org.mule.util.MapUtils;
import org.mule.util.ObjectUtils;

public class MessagePropertiesContext
implements Serializable {
    private static final long serialVersionUID = -5230693402768953742L;
    private static final PropertyScope DEFAULT_SCOPE = PropertyScope.OUTBOUND;
    private static Log logger = LogFactory.getLog(MessagePropertiesContext.class);
    protected CopyOnWriteCaseInsensitiveMap<String, Object> inboundMap;
    protected CopyOnWriteCaseInsensitiveMap<String, Object> outboundMap;
    protected Map<String, Object> invocationMap = new UndefinedInvocationPropertiesMap();
    protected transient Map<String, Object> sessionMap = new UndefinedSessionPropertiesMap();

    public MessagePropertiesContext() {
        this.inboundMap = new CopyOnWriteCaseInsensitiveMap();
        this.outboundMap = new CopyOnWriteCaseInsensitiveMap();
    }

    public MessagePropertiesContext(MessagePropertiesContext previous) {
        this.inboundMap = previous.inboundMap.clone();
        this.outboundMap = previous.outboundMap.clone();
        this.invocationMap = previous.invocationMap;
        this.sessionMap = previous.sessionMap;
    }

    protected Map<String, Object> getScopedProperties(PropertyScope scope) {
        if (PropertyScope.SESSION.equals(scope)) {
            return this.sessionMap;
        }
        if (PropertyScope.INVOCATION.equals(scope)) {
            return this.invocationMap;
        }
        if (PropertyScope.INBOUND.equals(scope)) {
            return this.inboundMap;
        }
        if (PropertyScope.OUTBOUND.equals(scope)) {
            return this.outboundMap;
        }
        throw new IllegalArgumentException("Scope not registered: " + scope);
    }

    public PropertyScope getDefaultScope() {
        return DEFAULT_SCOPE;
    }

    protected void addInboundProperties(Map<String, Object> properties) {
        if (properties != null) {
            this.getScopedProperties(PropertyScope.INBOUND).putAll(properties);
        }
    }

    @Deprecated
    public Object getProperty(String key) {
        return this.getProperty(key, PropertyScope.OUTBOUND);
    }

    public <T> T getProperty(String key, PropertyScope scope) {
        if (scope == null) {
            scope = PropertyScope.OUTBOUND;
        }
        return (T)this.getScopedProperties(scope).get(key);
    }

    public void clearProperties() {
        Map<String, Object> props = this.getScopedProperties(PropertyScope.INVOCATION);
        props.clear();
        props = this.getScopedProperties(PropertyScope.OUTBOUND);
        props.clear();
    }

    public void clearProperties(PropertyScope scope) {
        if (scope == null) {
            this.clearProperties();
            return;
        }
        Map<String, Object> props = this.getScopedProperties(scope);
        props.clear();
    }

    public Object removeProperty(String key) {
        Object value = this.getScopedProperties(PropertyScope.OUTBOUND).remove(key);
        Object inv = this.getScopedProperties(PropertyScope.INVOCATION).remove(key);
        if (value == null) {
            value = inv;
        }
        return value;
    }

    public Object removeProperty(String key, PropertyScope scope) {
        if (scope == null) {
            return this.removeProperty(key);
        }
        Object value = this.getScopedProperties(scope).remove(key);
        return value;
    }

    @Deprecated
    public void setProperty(String key, Object value) {
        this.getScopedProperties(DEFAULT_SCOPE).put(key, value);
    }

    public void setProperty(String key, Object value, PropertyScope scope) {
        if (!(value instanceof Serializable) && PropertyScope.SESSION.equals(scope)) {
            logger.warn((Object)CoreMessages.sessionPropertyNotSerializableWarning(key));
        }
        this.getScopedProperties(scope).put(key, value);
    }

    public Set<String> getPropertyNames(PropertyScope scope) {
        return Collections.unmodifiableSet(this.getScopedProperties(scope).keySet());
    }

    protected void checkScopeForWriteAccess(PropertyScope scope) {
        if (scope == null || PropertyScope.INBOUND.equals(scope)) {
            throw new IllegalArgumentException("Scope is invalid for writing properties: " + scope);
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        Object value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public byte getByteProperty(String name, byte defaultValue) {
        return ObjectUtils.getByte(this.getProperty(name), defaultValue);
    }

    public short getShortProperty(String name, short defaultValue) {
        return ObjectUtils.getShort(this.getProperty(name), defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return ObjectUtils.getInt(this.getProperty(name), defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return ObjectUtils.getLong(this.getProperty(name), defaultValue);
    }

    public float getFloatProperty(String name, float defaultValue) {
        return ObjectUtils.getFloat(this.getProperty(name), Float.valueOf(defaultValue));
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return ObjectUtils.getDouble(this.getProperty(name), defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return ObjectUtils.getBoolean(this.getProperty(name), defaultValue);
    }

    @Deprecated
    public String getStringProperty(String name, String defaultValue) {
        return this.getStringProperty(name, PropertyScope.OUTBOUND, defaultValue);
    }

    public String getStringProperty(String name, PropertyScope scope, String defaultValue) {
        return ObjectUtils.getString(this.getProperty(name, scope), defaultValue);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("Properties{");
        buf.append("inbound").append(":");
        buf.append(MapUtils.toString(this.inboundMap, false));
        buf.append(", ");
        buf.append("outbound").append(":");
        buf.append(MapUtils.toString(this.inboundMap, false));
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object value;
        for (Map.Entry<String, Object> entry : this.inboundMap.entrySet()) {
            value = entry.getValue();
            if (value == null || value instanceof Serializable) continue;
            String message = String.format("Unable to serialize the %s message property %s, which is of type %s ", PropertyScope.INBOUND, entry.getKey(), value);
            logger.error((Object)message);
            throw new IOException(message);
        }
        for (Map.Entry<String, Object> entry : this.outboundMap.entrySet()) {
            value = entry.getValue();
            if (value == null || value instanceof Serializable) continue;
            String message = String.format("Unable to serialize the %s message property %s, which is of type %s ", PropertyScope.OUTBOUND, entry.getKey(), value);
            logger.error((Object)message);
            throw new IOException(message);
        }
        if (this.invocationMap instanceof UndefinedInvocationPropertiesMap) {
            for (Map.Entry<String, Object> entry : this.invocationMap.entrySet()) {
                value = entry.getValue();
                if (value == null || value instanceof Serializable) continue;
                String message = String.format("Unable to serialize the invocation message property %s, which is of type %s ", entry.getKey(), value);
                logger.error((Object)message);
                throw new IOException(message);
            }
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.sessionMap = new UndefinedSessionPropertiesMap();
    }

    protected Map<String, Object> getOrphanFlowVariables() {
        if (this.invocationMap instanceof UndefinedInvocationPropertiesMap) {
            return this.invocationMap;
        }
        return Collections.emptyMap();
    }

    private static class UndefinedInvocationPropertiesMap
    extends CaseInsensitiveHashMap {
        private static final long serialVersionUID = 8400889672358403911L;

        private UndefinedInvocationPropertiesMap() {
        }
    }

    private static class UndefinedSessionPropertiesMap
    extends AbstractMap<String, Object>
    implements Serializable {
        private static final long serialVersionUID = -7982608304570908737L;

        private UndefinedSessionPropertiesMap() {
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public Object put(String key, Object value) {
            throw new IllegalStateException(String.format("Detected an attempt to set a invocation or session property, but a MuleEvent hasn't been created using this message yet. Key/value: %s=%s", key, value));
        }

        @Override
        public Object get(Object key) {
            logger.warn((Object)String.format("Detected an attempt to get a invocation or session property, but a MuleEvent hasn't been created using this message yet. Key: %s", key));
            return null;
        }
    }
}

