/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mule.util.CaseInsensitiveHashMap;

public class CopyOnWriteCaseInsensitiveMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -2753436627413265538L;
    private Map<K, V> core;
    private transient Map<K, V> view;
    private transient boolean requiresCopy;

    public CopyOnWriteCaseInsensitiveMap() {
        this.updateCore((Map<K, V>)((Object)new CaseInsensitiveHashMap()));
    }

    private CopyOnWriteCaseInsensitiveMap(CopyOnWriteCaseInsensitiveMap<K, V> that) {
        this.updateCore(that.core);
        this.requiresCopy = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyOnWriteCaseInsensitiveMap<K, V> clone() {
        try {
            CopyOnWriteCaseInsensitiveMap<K, V> copyOnWriteCaseInsensitiveMap = new CopyOnWriteCaseInsensitiveMap<K, V>(this);
            return copyOnWriteCaseInsensitiveMap;
        }
        finally {
            this.requiresCopy = true;
        }
    }

    private void copy() {
        if (this.requiresCopy) {
            this.updateCore((Map<K, V>)((Object)new CaseInsensitiveHashMap(this.core)));
            this.requiresCopy = false;
        }
    }

    @Override
    public int size() {
        return this.core.size();
    }

    @Override
    public boolean isEmpty() {
        return this.core.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.core.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.core.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.core.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.copy();
        return this.core.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.copy();
        return this.core.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.copy();
        this.core.putAll(t);
    }

    @Override
    public void clear() {
        this.updateCore((Map<K, V>)((Object)new CaseInsensitiveHashMap()));
    }

    @Override
    public Set<K> keySet() {
        return this.view.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.view.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.view.entrySet();
    }

    public String toString() {
        return this.core.toString();
    }

    private void updateCore(Map<K, V> core) {
        this.core = core;
        this.view = Collections.unmodifiableMap(core);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.view = Collections.unmodifiableMap(this.core);
    }
}

