/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.transformer.CompositeConverter;
import org.mule.transformer.graph.ConverterFilter;

public class TransformationLengthConverterFilter
implements ConverterFilter {
    @Override
    public List<Converter> filter(List<Converter> converters, DataType<?> source, DataType<?> result) {
        int index;
        if (converters.size() == 0) {
            return Collections.emptyList();
        }
        this.sortByTransformationLength(converters);
        int shortestLength = this.getTransformationLength(converters.get(0));
        for (index = 1; index < converters.size() && this.getTransformationLength(converters.get(index)) <= shortestLength; ++index) {
        }
        return converters.subList(0, index);
    }

    private void sortByTransformationLength(List<Converter> converterss) {
        Collections.sort(converterss, new Comparator<Converter>(){

            @Override
            public int compare(Converter converter, Converter converter1) {
                int length = TransformationLengthConverterFilter.this.getTransformationLength(converter);
                int length1 = TransformationLengthConverterFilter.this.getTransformationLength(converter1);
                return length - length1;
            }
        });
    }

    private int getTransformationLength(Converter converter) {
        if (converter instanceof CompositeConverter) {
            return ((CompositeConverter)converter).getConverters().size();
        }
        return 1;
    }
}

