/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DataTypeConversionResolver;
import org.mule.api.MuleContext;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;

public class DynamicDataTypeConversionResolver
implements DataTypeConversionResolver {
    private static final Log logger = LogFactory.getLog(DynamicDataTypeConversionResolver.class);
    private final MuleContext muleContext;

    public DynamicDataTypeConversionResolver(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public Transformer resolve(DataType<?> sourceType, List<DataType<?>> targetDataTypes) {
        Transformer transformer = null;
        for (DataType<?> targetDataType : targetDataTypes) {
            try {
                transformer = this.muleContext.getRegistry().lookupTransformer(sourceType, targetDataType);
                if (transformer == null) continue;
                break;
            }
            catch (TransformerException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Unable to find an implicit conversion from " + sourceType + " to " + targetDataType));
            }
        }
        return transformer;
    }
}

