/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.config.i18n.CoreMessages;

public class SplitMessage {
    private List<MessagePart> parts = new ArrayList<MessagePart>();

    public void addPart(Object part, OutboundEndpoint endpoint) {
        this.parts.add(new MessagePart(endpoint, part));
    }

    public MessagePart getPart(int i) {
        return this.parts.get(i);
    }

    public int size() {
        return this.parts.size();
    }

    public class MessagePart {
        private Object part;
        private OutboundEndpoint endpoint;

        public MessagePart(OutboundEndpoint endpoint, Object part) {
            if (endpoint == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("splitter endpoint").getMessage());
            }
            if (part == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("splitter messagePart").getMessage());
            }
            this.endpoint = endpoint;
            this.part = part;
        }

        public OutboundEndpoint getEndpoint() {
            return this.endpoint;
        }

        public Object getPart() {
            return this.part;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("MessagePart");
            sb.append("{endpoint=").append(this.endpoint.getName());
            sb.append(", part=").append(this.part);
            sb.append('}');
            return sb.toString();
        }
    }
}

