/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.store.ListableObjectStore;
import org.mule.config.i18n.MessageFactory;
import org.mule.routing.AsynchronousUntilSuccessfulProcessingStrategy;
import org.mule.routing.SynchronousUntilSuccessfulProcessingStrategy;
import org.mule.routing.UntilSuccessfulConfiguration;
import org.mule.routing.UntilSuccessfulProcessingStrategy;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.routing.outbound.AbstractOutboundRouter;

public class UntilSuccessful
extends AbstractOutboundRouter
implements UntilSuccessfulConfiguration {
    public static final String PROCESS_ATTEMPT_COUNT_PROPERTY_NAME = "process.attempt.count";
    static final int DEFAULT_PROCESS_ATTEMPT_COUNT_PROPERTY_VALUE = 1;
    private ListableObjectStore<MuleEvent> objectStore;
    private int maxRetries = 5;
    private long secondsBetweenRetries = 60L;
    private String failureExpression;
    private String ackExpression;
    private ExpressionFilter failureExpressionFilter;
    private String eventKeyPrefix;
    private Object deadLetterQueue;
    private MessageProcessor dlqMP;
    private boolean synchronous = false;
    private ThreadingProfile threadingProfile;
    private UntilSuccessfulProcessingStrategy untilSuccessfulStrategy;

    @Override
    public void initialise() throws InitialisationException {
        if (this.routes.isEmpty()) {
            throw new InitialisationException(MessageFactory.createStaticMessage("One message processor must be configured within UntilSuccessful."), (Initialisable)this);
        }
        if (this.routes.size() > 1) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Only one message processor is allowed within UntilSuccessful. Use a Processor Chain to group several message processors into one."), (Initialisable)this);
        }
        super.initialise();
        if (this.deadLetterQueue != null) {
            if (this.deadLetterQueue instanceof EndpointBuilder) {
                try {
                    this.dlqMP = ((EndpointBuilder)this.deadLetterQueue).buildOutboundEndpoint();
                }
                catch (EndpointException ee) {
                    throw new InitialisationException(MessageFactory.createStaticMessage("deadLetterQueue-ref is not a valid endpoint builder: " + this.deadLetterQueue), (Throwable)ee, this);
                }
            } else if (this.deadLetterQueue instanceof MessageProcessor) {
                this.dlqMP = (MessageProcessor)this.deadLetterQueue;
            } else {
                throw new InitialisationException(MessageFactory.createStaticMessage("deadLetterQueue-ref is not a valid mesage processor: " + this.deadLetterQueue), null, this);
            }
        }
        this.failureExpressionFilter = this.failureExpression != null ? new ExpressionFilter(this.failureExpression) : new ExpressionFilter("exception-type:");
        this.failureExpressionFilter.setMuleContext(this.muleContext);
        if (this.ackExpression != null && !this.muleContext.getExpressionManager().isExpression(this.ackExpression)) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Invalid ackExpression: " + this.ackExpression), (Initialisable)this);
        }
        if (this.synchronous) {
            this.untilSuccessfulStrategy = new SynchronousUntilSuccessfulProcessingStrategy();
        } else {
            if (this.threadingProfile == null) {
                this.threadingProfile = this.muleContext.getDefaultThreadingProfile();
            }
            this.untilSuccessfulStrategy = new AsynchronousUntilSuccessfulProcessingStrategy();
        }
        this.untilSuccessfulStrategy.setUntilSuccessfulConfiguration(this);
        if (this.untilSuccessfulStrategy instanceof Initialisable) {
            ((Initialisable)((Object)this.untilSuccessfulStrategy)).initialise();
        }
        String flowName = this.flowConstruct.getName();
        String clusterId = this.muleContext.getClusterId();
        this.eventKeyPrefix = flowName + "-" + clusterId + "-";
    }

    @Override
    public void start() throws MuleException {
        super.start();
        if (this.untilSuccessfulStrategy instanceof Startable) {
            ((Startable)((Object)this.untilSuccessfulStrategy)).start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.untilSuccessfulStrategy instanceof Stoppable) {
            ((Stoppable)((Object)this.untilSuccessfulStrategy)).stop();
        }
        super.stop();
    }

    @Override
    public boolean isMatch(MuleMessage message) throws MuleException {
        return true;
    }

    @Override
    protected MuleEvent route(MuleEvent event) throws MessagingException {
        return this.untilSuccessfulStrategy.route(event);
    }

    @Override
    public ListableObjectStore<MuleEvent> getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ListableObjectStore<MuleEvent> objectStore) {
        this.objectStore = objectStore;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public long getSecondsBetweenRetries() {
        return this.secondsBetweenRetries;
    }

    public void setSecondsBetweenRetries(long secondsBetweenRetries) {
        this.secondsBetweenRetries = secondsBetweenRetries;
    }

    public String getFailureExpression() {
        return this.failureExpression;
    }

    public void setFailureExpression(String failureExpression) {
        this.failureExpression = failureExpression;
    }

    @Override
    public String getAckExpression() {
        return this.ackExpression;
    }

    public void setAckExpression(String ackExpression) {
        this.ackExpression = ackExpression;
    }

    public void setDeadLetterQueue(Object deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue;
    }

    public Object getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public String getEventKeyPrefix() {
        return this.eventKeyPrefix;
    }

    @Override
    public ExpressionFilter getFailureExpressionFilter() {
        return this.failureExpressionFilter;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    @Override
    public ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    @Override
    public MessageProcessor getDlqMP() {
        return this.dlqMP;
    }

    @Override
    public MessageProcessor getRoute() {
        return (MessageProcessor)this.routes.get(0);
    }

    @Override
    public AbstractOutboundRouter getRouter() {
        return this;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

