/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.NameableObject;
import org.mule.api.agent.Agent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.model.Model;
import org.mule.api.registry.AbstractServiceDescriptor;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.ServiceDescriptor;
import org.mule.api.registry.ServiceDescriptorFactory;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.schedule.Scheduler;
import org.mule.api.service.Service;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.registry.DefaultRegistryBroker;
import org.mule.registry.TypeBasedTransformerResolver;
import org.mule.transformer.types.SimpleDataType;
import org.mule.util.Predicate;
import org.mule.util.SpiUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

public class MuleRegistryHelper
implements MuleRegistry {
    protected transient Log logger = LogFactory.getLog(MuleRegistryHelper.class);
    private DefaultRegistryBroker registry;
    protected ConcurrentHashMap exactTransformerCache = new ConcurrentHashMap(8);
    protected ConcurrentHashMap transformerListCache = new ConcurrentHashMap(8);
    private MuleContext muleContext;

    public MuleRegistryHelper(DefaultRegistryBroker registry, MuleContext muleContext) {
        this.registry = registry;
        this.muleContext = muleContext;
    }

    @Override
    public void initialise() throws InitialisationException {
    }

    @Override
    public void dispose() {
        this.transformerListCache.clear();
        this.exactTransformerCache.clear();
    }

    @Override
    public void fireLifecycle(String phase) throws LifecycleException {
        if ("initialise".equals(phase)) {
            this.registry.initialise();
        } else if ("dispose".equals(phase)) {
            this.registry.dispose();
        } else {
            this.registry.fireLifecycle(phase);
        }
    }

    @Override
    public Connector lookupConnector(String name) {
        return (Connector)this.registry.lookupObject(name);
    }

    @Override
    public EndpointBuilder lookupEndpointBuilder(String name) {
        Object o = this.registry.lookupObject(name);
        if (o instanceof EndpointBuilder) {
            this.logger.debug((Object)("Global endpoint EndpointBuilder for name: " + name + " found"));
            return (EndpointBuilder)o;
        }
        this.logger.debug((Object)("No endpoint builder with the name: " + name + " found."));
        return null;
    }

    @Override
    public EndpointFactory lookupEndpointFactory() {
        return (EndpointFactory)this.registry.lookupObject("_muleEndpointFactory");
    }

    @Override
    public Transformer lookupTransformer(String name) {
        return (Transformer)this.registry.lookupObject(name);
    }

    @Deprecated
    public Transformer lookupTransformer(Class inputType, Class outputType) throws TransformerException {
        return this.lookupTransformer((DataType)new SimpleDataType(inputType), (DataType)new SimpleDataType(outputType));
    }

    @Deprecated
    public List<Transformer> lookupTransformers(Class input, Class output) {
        return this.lookupTransformers((DataType)new SimpleDataType(input), (DataType)new SimpleDataType(output));
    }

    public Transformer lookupTransformer(DataType source, DataType result) throws TransformerException {
        String dataTypePairHash = this.getDataTypeSourceResultPairHash(source, result);
        Transformer cachedTransformer = (Transformer)this.exactTransformerCache.get(dataTypePairHash);
        if (cachedTransformer != null) {
            return cachedTransformer;
        }
        Transformer trans = this.resolveTransformer(source, result);
        if (trans != null) {
            Transformer concurrentlyAddedTransformer = this.exactTransformerCache.putIfAbsent(dataTypePairHash, trans);
            if (concurrentlyAddedTransformer != null) {
                return concurrentlyAddedTransformer;
            }
            return trans;
        }
        throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, result));
    }

    protected Transformer resolveTransformer(DataType source, DataType result) throws TransformerException {
        List resolvers = (List)this.lookupObjects(TransformerResolver.class);
        Collections.sort(resolvers, new TransformerResolverComparator());
        for (TransformerResolver resolver : resolvers) {
            try {
                Transformer trans = resolver.resolve(source, result);
                if (trans == null) continue;
                return trans;
            }
            catch (ResolverException e) {
                throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, result), (Throwable)e);
            }
        }
        return null;
    }

    public List<Transformer> lookupTransformers(DataType source, DataType result) {
        String dataTypePairHash = this.getDataTypeSourceResultPairHash(source, result);
        ArrayList<Transformer> results = (ArrayList<Transformer>)this.transformerListCache.get(dataTypePairHash);
        if (results != null) {
            return results;
        }
        results = new ArrayList<Transformer>(2);
        Collection<Transformer> transformers = this.registry.lookupObjects(Transformer.class);
        for (Transformer t : transformers) {
            DataType<?> dt;
            if (!(t instanceof Converter) || !result.isCompatibleWith(dt = t.getReturnDataType()) || !t.isSourceDataTypeSupported(source)) continue;
            results.add(t);
        }
        List concurrentlyAddedTransformers = this.transformerListCache.putIfAbsent(dataTypePairHash, results);
        if (concurrentlyAddedTransformers != null) {
            return concurrentlyAddedTransformers;
        }
        return results;
    }

    @Override
    @Deprecated
    public Model lookupModel(String name) {
        return (Model)this.registry.lookupObject(name);
    }

    @Override
    @Deprecated
    public Model lookupSystemModel() {
        return this.lookupModel("_muleSystemModel");
    }

    @Override
    @Deprecated
    public Collection<Model> getModels() {
        return this.registry.lookupObjects(Model.class);
    }

    @Override
    public Collection<Connector> getConnectors() {
        return this.registry.lookupObjects(Connector.class);
    }

    @Override
    public Collection<Agent> getAgents() {
        return this.registry.lookupObjects(Agent.class);
    }

    @Override
    public Collection<ImmutableEndpoint> getEndpoints() {
        return this.registry.lookupObjects(ImmutableEndpoint.class);
    }

    @Override
    public Collection<Transformer> getTransformers() {
        return this.registry.lookupObjects(Transformer.class);
    }

    @Override
    public Agent lookupAgent(String name) {
        return (Agent)this.registry.lookupObject(name);
    }

    @Override
    public Service lookupService(String name) {
        return (Service)this.registry.lookupObject(name);
    }

    @Override
    public Collection<Service> lookupServices() {
        return this.lookupObjects(Service.class);
    }

    @Override
    public Collection<Service> lookupServices(String model) {
        Collection<Service> services = this.lookupServices();
        ArrayList<Service> modelServices = new ArrayList<Service>();
        for (Service service : services) {
            if (!model.equals(service.getModel().getName())) continue;
            modelServices.add(service);
        }
        return modelServices;
    }

    @Override
    public FlowConstruct lookupFlowConstruct(String name) {
        return (FlowConstruct)this.registry.lookupObject(name);
    }

    @Override
    public Collection<FlowConstruct> lookupFlowConstructs() {
        return this.lookupObjects(FlowConstruct.class);
    }

    @Override
    public final void registerTransformer(Transformer transformer) throws MuleException {
        this.registry.registerObject(this.getName(transformer), transformer, Transformer.class);
        this.notifyTransformerResolvers(transformer, TransformerResolver.RegistryAction.ADDED);
    }

    public void notifyTransformerResolvers(Transformer t, TransformerResolver.RegistryAction action) {
        if (t instanceof Converter) {
            Collection<TransformerResolver> resolvers = this.lookupObjects(TransformerResolver.class);
            for (TransformerResolver resolver : resolvers) {
                resolver.transformerChange(t, action);
            }
            this.transformerListCache.clear();
            this.exactTransformerCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceDescriptor lookupServiceDescriptor(ServiceType type, String name, Properties overrides) throws ServiceException {
        String key = new AbstractServiceDescriptor.Key(name, overrides).getKey();
        ServiceDescriptor sd = (ServiceDescriptor)this.registry.lookupObject(key);
        MuleRegistryHelper muleRegistryHelper = this;
        synchronized (muleRegistryHelper) {
            if (sd == null) {
                sd = this.createServiceDescriptor(type, name, overrides);
                try {
                    this.registry.registerObject(key, sd, ServiceDescriptor.class);
                }
                catch (RegistrationException e) {
                    throw new ServiceException(e.getI18nMessage(), (Throwable)e);
                }
            }
        }
        return sd;
    }

    protected ServiceDescriptor createServiceDescriptor(ServiceType type, String name, Properties overrides) throws ServiceException {
        Properties props;
        String scheme = name;
        if (name.contains(":")) {
            scheme = name.substring(0, name.indexOf(":"));
        }
        if ((props = SpiUtils.findServiceDescriptor(type, scheme)) == null) {
            throw new ServiceException(CoreMessages.failedToLoad((Object)((Object)type) + " " + scheme));
        }
        return ServiceDescriptorFactory.create(type, name, props, overrides, this.muleContext, this.muleContext.getExecutionClassLoader());
    }

    @Override
    public void registerAgent(Agent agent) throws MuleException {
        this.registry.registerObject(this.getName(agent), agent, Agent.class);
    }

    @Override
    public void registerConnector(Connector connector) throws MuleException {
        this.registry.registerObject(this.getName(connector), connector, Connector.class);
    }

    @Override
    public void registerEndpoint(ImmutableEndpoint endpoint) throws MuleException {
        this.registry.registerObject(this.getName(endpoint), endpoint, ImmutableEndpoint.class);
    }

    @Override
    public void registerEndpointBuilder(String name, EndpointBuilder builder) throws MuleException {
        this.registry.registerObject(name, builder, EndpointBuilder.class);
    }

    @Override
    @Deprecated
    public void registerModel(Model model) throws MuleException {
        this.registry.registerObject(this.getName(model), model, Model.class);
    }

    @Override
    public void registerService(Service service) throws MuleException {
        this.registry.registerObject(this.getName(service), service, Service.class);
    }

    @Override
    public void unregisterService(String serviceName) throws MuleException {
        this.registry.unregisterObject(serviceName, Service.class);
    }

    @Override
    public void registerFlowConstruct(FlowConstruct flowConstruct) throws MuleException {
        this.registry.registerObject(this.getName(flowConstruct), flowConstruct, FlowConstruct.class);
    }

    @Override
    public void unregisterFlowConstruct(String flowConstructName) throws MuleException {
        this.registry.unregisterObject(flowConstructName, FlowConstruct.class);
    }

    @Override
    public void unregisterAgent(String agentName) throws MuleException {
        this.registry.unregisterObject(agentName, Agent.class);
    }

    @Override
    public void registerScheduler(Scheduler scheduler) throws MuleException {
        this.registry.registerObject(scheduler.getName(), scheduler);
    }

    @Override
    public void unregisterScheduler(Scheduler scheduler) throws MuleException {
        this.registry.unregisterObject(scheduler.getName(), scheduler);
    }

    @Override
    public Collection<Scheduler> lookupScheduler(Predicate<String> schedulerNamePredicate) {
        ArrayList<Scheduler> schedulers = new ArrayList<Scheduler>();
        Map<String, Scheduler> registeredSchedulers = this.lookupByType(Scheduler.class);
        for (Scheduler registeredScheduler : registeredSchedulers.values()) {
            if (!schedulerNamePredicate.evaluate(registeredScheduler.getName())) continue;
            schedulers.add(registeredScheduler);
        }
        return schedulers;
    }

    @Override
    public void unregisterConnector(String connectorName) throws MuleException {
        this.registry.unregisterObject(connectorName, Connector.class);
    }

    @Override
    public void unregisterEndpoint(String endpointName) throws MuleException {
        this.registry.unregisterObject(endpointName, ImmutableEndpoint.class);
    }

    @Override
    @Deprecated
    public void unregisterModel(String modelName) throws MuleException {
        this.registry.unregisterObject(modelName, Model.class);
    }

    @Override
    public void unregisterTransformer(String transformerName) throws MuleException {
        Transformer transformer = this.lookupTransformer(transformerName);
        this.notifyTransformerResolvers(transformer, TransformerResolver.RegistryAction.REMOVED);
        this.registry.unregisterObject(transformerName, Transformer.class);
    }

    @Override
    public Object applyProcessorsAndLifecycle(Object object) throws MuleException {
        object = this.applyProcessors(object);
        object = this.applyLifecycle(object);
        return object;
    }

    @Override
    public Object applyProcessors(Object object) throws MuleException {
        return this.registry.getTransientRegistry().applyProcessors(object, null);
    }

    @Override
    public Object applyProcessors(Object object, int flags) throws MuleException {
        return this.registry.getTransientRegistry().applyProcessors(object, flags);
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        return this.registry.getTransientRegistry().applyLifecycle(object);
    }

    @Override
    public Object applyLifecycle(Object object, String phase) throws MuleException {
        return this.registry.getTransientRegistry().applyLifecycle(object, phase);
    }

    @Override
    public <T> T lookupObject(Class<T> type) throws RegistrationException {
        return this.registry.lookupObject(type);
    }

    @Override
    public <T> T lookupObject(String key) {
        return this.registry.lookupObject(key);
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> type) {
        return this.registry.lookupObjects(type);
    }

    @Override
    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        return this.registry.lookupObjectsForLifecycle(type);
    }

    @Override
    public <T> T get(String key) {
        return this.registry.get(key);
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.registry.lookupByType(type);
    }

    @Override
    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registry.registerObject(key, value, metadata);
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registry.registerObject(key, value);
    }

    public void registerObjects(Map objects) throws RegistrationException {
        this.registry.registerObjects(objects);
    }

    @Override
    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        this.registry.unregisterObject(key, metadata);
    }

    @Override
    public void unregisterObject(String key) throws RegistrationException {
        this.registry.unregisterObject(key);
    }

    protected String getName(Object obj) {
        String name = null;
        if (obj instanceof NameableObject) {
            name = ((NameableObject)obj).getName();
        } else if (obj instanceof FlowConstruct) {
            name = ((FlowConstruct)obj).getName();
        }
        if (StringUtils.isBlank((String)name)) {
            name = obj.getClass().getName() + ":" + UUID.getUUID();
        }
        return name;
    }

    @Override
    public String getRegistryId() {
        return this.toString();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    private String getDataTypeSourceResultPairHash(DataType<?> source, DataType<?> result) {
        return source.getClass().getName() + source.hashCode() + ":" + result.getClass().getName() + result.hashCode();
    }

    private class TransformerResolverComparator
    implements Comparator<TransformerResolver> {
        private TransformerResolverComparator() {
        }

        @Override
        public int compare(TransformerResolver transformerResolver, TransformerResolver transformerResolver1) {
            if (transformerResolver.getClass().equals(TypeBasedTransformerResolver.class)) {
                return 1;
            }
            if (transformerResolver1.getClass().equals(TypeBasedTransformerResolver.class)) {
                return -1;
            }
            return 0;
        }
    }
}

