/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.api.el.VariableAssignmentCallback;
import org.mule.config.i18n.CoreMessages;
import org.mule.el.mvel.MVELFunctionAdaptor;
import org.mule.el.mvel.MuleAliasVariableResolver;
import org.mule.el.mvel.MuleVariableResolver;
import org.mule.mvel2.ImmutableElementException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.ast.FunctionInstance;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mule.mvel2.integration.impl.SimpleVariableResolverFactory;

public class MVELExpressionLanguageContext
extends BaseVariableResolverFactory
implements ExpressionLanguageContext {
    private static final long serialVersionUID = 909413730991198290L;
    public static final String MULE_MESSAGE_INTERNAL_VARIABLE = "_muleMessage";
    public static final String MULE_CONTEXT_INTERNAL_VARIABLE = "_muleContext";
    protected ParserConfiguration parserConfiguration;
    protected MuleContext muleContext;
    protected InternalVariableResolverFactory localFactory;
    protected Map<String, Object> privateVariables = new HashMap<String, Object>();

    public MVELExpressionLanguageContext(ParserConfiguration parserConfiguration, MuleContext muleContext) {
        this.parserConfiguration = parserConfiguration;
        this.muleContext = muleContext;
        this.localFactory = new InternalVariableResolverFactory(Collections.<String, Object>emptyMap());
        this.nextFactory = this.localFactory;
    }

    public MVELExpressionLanguageContext(MVELExpressionLanguageContext context) {
        this.parserConfiguration = context.parserConfiguration;
        this.muleContext = context.muleContext;
        this.localFactory = context.localFactory;
        this.nextFactory = context.nextFactory;
        this.variableResolvers = context.variableResolvers;
    }

    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    public boolean isResolveable(String name) {
        return this.isTarget(name) || this.isNextResolveable(name);
    }

    public VariableResolver createVariable(String name, Object value) {
        return this.createVariable(name, value, null);
    }

    public VariableResolver getVariableResolver(String name) {
        VariableResolver variableResolver = (VariableResolver)this.variableResolvers.get(name);
        if (variableResolver == null) {
            variableResolver = this.nextFactory.getVariableResolver(name);
        }
        return variableResolver;
    }

    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        Object vr = this.getVariableResolver(name);
        if (vr != null) {
            vr.setValue(value);
        } else {
            vr = new MuleVariableResolver<Object>(name, value, type, null);
            this.addResolver(name, (VariableResolver)vr);
        }
        return vr;
    }

    @Override
    public <T> void addVariable(String name, T value) {
        this.addResolver(name, (VariableResolver)new MuleVariableResolver<T>(name, value, value != null ? value.getClass() : null, null));
    }

    @Override
    public <T> void addVariable(String name, T value, VariableAssignmentCallback<T> assignmentCallback) {
        this.addResolver(name, (VariableResolver)new MuleVariableResolver<T>(name, value, value != null ? value.getClass() : null, assignmentCallback));
    }

    @Override
    public <T> void addFinalVariable(String name, T value) {
        this.addVariable(name, value, new VariableAssignmentCallback<T>(){

            @Override
            public void assignValue(String name, T value, T newValue) {
                throw new ImmutableElementException(CoreMessages.expressionFinalVariableCannotBeAssignedValue(name).getMessage());
            }
        });
    }

    @Override
    public <T> T getVariable(String name) {
        if (this.privateVariables.containsKey(name)) {
            return (T)this.privateVariables.get(name);
        }
        VariableResolver resolver = this.getVariableResolver(name);
        if (resolver != null) {
            return (T)resolver.getValue();
        }
        return null;
    }

    @Override
    public <T> T getVariable(String name, Class<T> type) {
        return this.getVariable(name);
    }

    protected void addResolver(String name, VariableResolver vr) {
        if (this.getClass().equals(MVELExpressionLanguageContext.class)) {
            this.localFactory.addResolver(name, vr);
        } else {
            this.variableResolvers.put(name, vr);
        }
    }

    @Override
    public void addAlias(String alias, String expression) {
        this.addResolver(alias, (VariableResolver)new MuleAliasVariableResolver(alias, expression, this.getParentContext()));
    }

    @Override
    public void importClass(Class<?> clazz) {
        if (this.parserConfiguration.hasImport(clazz.getSimpleName())) {
            this.parserConfiguration.addImport(clazz);
        }
    }

    @Override
    public void importClass(String name, Class<?> clazz) {
        if (!this.parserConfiguration.hasImport(name)) {
            this.parserConfiguration.addImport(name, clazz);
        }
    }

    @Override
    public void importStaticMethod(String name, Method method) {
        if (!this.parserConfiguration.hasImport(name)) {
            this.parserConfiguration.addImport(name, method);
        }
    }

    @Override
    public boolean contains(String name) {
        return this.isResolveable(name);
    }

    @Override
    public void declareFunction(String name, ExpressionLanguageFunction function) {
        this.addFinalVariable(name, new FunctionInstance((Function)new MVELFunctionAdaptor(name, function, new ParserContext(this.parserConfiguration))));
    }

    public void appendFactory(VariableResolverFactory resolverFactory) {
        if (this.nextFactory instanceof InternalVariableResolverFactory) {
            this.setNextFactory(resolverFactory);
            resolverFactory.setNextFactory((VariableResolverFactory)this.localFactory);
        } else {
            VariableResolverFactory vrf = this.nextFactory;
            while (vrf.getNextFactory() != null && !(vrf.getNextFactory() instanceof InternalVariableResolverFactory)) {
                vrf = vrf.getNextFactory();
            }
            vrf.setNextFactory(resolverFactory);
            resolverFactory.setNextFactory((VariableResolverFactory)this.localFactory);
        }
    }

    public void insertFactory(VariableResolverFactory resolverFactory) {
        if (this.nextFactory == null) {
            this.nextFactory = resolverFactory;
        } else {
            VariableResolverFactory currentNext = this.nextFactory;
            this.nextFactory = resolverFactory;
            resolverFactory.setNextFactory(currentNext);
        }
    }

    MVELExpressionLanguageContext getParentContext() {
        return this;
    }

    @Override
    public <T> void addPrivateVariable(String name, T value) {
        this.privateVariables.put(name, value);
    }

    class InternalVariableResolverFactory
    extends SimpleVariableResolverFactory {
        public InternalVariableResolverFactory(Map<String, Object> variables) {
            super(variables);
        }

        public void addResolver(String name, VariableResolver resolver) {
            this.variableResolvers.put(name, resolver);
        }
    }
}

