/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueStore;
import org.mule.util.queue.TransactionContextProvider;
import org.mule.util.store.DeserializationPostInitialisable;

public class TransactionAwareQueueStore
implements Queue {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final MuleContext muleContext;
    private final TransactionContextProvider transactionContextProvider;
    private final QueueStore queue;

    public TransactionAwareQueueStore(QueueStore queue, TransactionContextProvider transactionContextProvider, MuleContext muleContext) {
        this.queue = queue;
        this.transactionContextProvider = transactionContextProvider;
        this.muleContext = muleContext;
    }

    @Override
    public void put(Serializable item) throws InterruptedException, ObjectStoreException {
        this.offer(item, Long.MAX_VALUE);
    }

    @Override
    public void clear() throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            this.transactionContextProvider.getTransactionalContext().clear(this.queue);
        } else {
            this.queue.clear();
        }
    }

    @Override
    public boolean offer(Serializable item, long timeout) throws InterruptedException, ObjectStoreException {
        if (this.transactionContextProvider.isTransactional()) {
            return this.transactionContextProvider.getTransactionalContext().offer(this.queue, item, timeout);
        }
        return this.queue.offer(item, 0, timeout);
    }

    @Override
    public Serializable take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE);
    }

    @Override
    public void untake(Serializable item) throws InterruptedException, ObjectStoreException {
        if (this.transactionContextProvider.isTransactional()) {
            this.transactionContextProvider.getTransactionalContext().untake(this.queue, item);
        } else {
            this.queue.untake(item);
        }
    }

    @Override
    public Serializable poll(long timeout) throws InterruptedException {
        try {
            if (this.transactionContextProvider.isTransactional()) {
                Serializable item = this.transactionContextProvider.getTransactionalContext().poll(this.queue, timeout);
                return this.postProcessIfNeeded(item);
            }
            return this.postProcessIfNeeded(this.queue.poll(timeout));
        }
        catch (InterruptedException iex) {
            if (!this.muleContext.isStopping()) {
                throw iex;
            }
            return null;
        }
    }

    @Override
    public Serializable peek() throws InterruptedException {
        if (this.transactionContextProvider.isTransactional()) {
            Serializable item = this.transactionContextProvider.getTransactionalContext().peek(this.queue);
            return this.postProcessIfNeeded(item);
        }
        return this.postProcessIfNeeded(this.queue.peek());
    }

    @Override
    public void dispose() throws MuleException, InterruptedException {
        this.queue.dispose();
    }

    @Override
    public int size() {
        if (this.transactionContextProvider.isTransactional()) {
            return this.transactionContextProvider.getTransactionalContext().size(this.queue);
        }
        return this.queue.getSize();
    }

    @Override
    public String getName() {
        return this.queue.getName();
    }

    private Serializable postProcessIfNeeded(Serializable item) {
        try {
            if (item instanceof DeserializationPostInitialisable) {
                DeserializationPostInitialisable.Implementation.init(item, this.muleContext);
            }
            return item;
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unable to deserialize message", (Throwable)e);
            return null;
        }
    }
}

