/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.counters.impl;

import org.mule.util.counters.CounterFactory;
import org.mule.util.counters.impl.AbstractCounter;
import org.mule.util.counters.impl.AggregateCounter;

public class Delta
extends AggregateCounter {
    private double first = 0.0;
    private double second = 0.0;

    public Delta(String name, AbstractCounter base) {
        super(name, CounterFactory.Type.DELTA, base);
    }

    @Override
    public double nextValue() {
        if (Double.isNaN(this.first) || Double.isNaN(this.second)) {
            return Double.NaN;
        }
        return this.second - this.first > 0.0 ? this.second - this.first : 0.0;
    }

    @Override
    public void doCompute() {
        this.first = this.second;
        this.second = this.getBase().nextValue();
    }
}

