/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.transport.Connector;
import org.mule.util.StringUtils;

public final class ObjectNameHelper {
    public static final String SEPARATOR = ".";
    public static final String CONNECTOR_PREFIX = "connector";
    public static final String ENDPOINT_PREFIX = "endpoint";
    public static final String DEFAULT = "mule.default";
    private MuleContext muleContext;

    public ObjectNameHelper(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getEndpointName(EndpointURI endpointUri) {
        String name = ObjectNameHelper.getEndpointNameFor(endpointUri);
        return this.ensureUniqueEndpoint(name);
    }

    public static String getEndpointNameFor(EndpointURI endpointUri) {
        String address = endpointUri.getAddress();
        if (StringUtils.isBlank((String)address)) {
            address = endpointUri.toString();
        }
        address = address.indexOf(":/") > -1 ? address : endpointUri.getScheme() + SEPARATOR + address;
        return "endpoint." + ObjectNameHelper.replaceObjectNameChars(address);
    }

    protected String ensureUniqueEndpoint(String name) {
        int i = 0;
        String tempName = name;
        while (this.muleContext.getRegistry().lookupObject(tempName) != null) {
            tempName = name + SEPARATOR + ++i;
        }
        return tempName;
    }

    protected String ensureUniqueConnector(String name) {
        int i = 0;
        String tempName = name;
        try {
            while (this.muleContext.getRegistry().lookupConnector(tempName) != null) {
                tempName = name + SEPARATOR + ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return tempName;
    }

    public String getConnectorName(Connector connector) {
        if (connector.getName() != null && connector.getName().indexOf(35) == -1) {
            String name = ObjectNameHelper.replaceObjectNameChars(connector.getName());
            return this.ensureUniqueConnector(name);
        }
        String name = "connector." + connector.getProtocol() + SEPARATOR + DEFAULT;
        return this.ensureUniqueConnector(name);
    }

    public static boolean isDefaultAutoGeneratedConnector(Connector connector) {
        return connector.getName().startsWith("connector." + connector.getProtocol() + SEPARATOR + DEFAULT);
    }

    public static String replaceObjectNameChars(String name) {
        String value = name.replaceAll("//", SEPARATOR);
        value = value.replaceAll("\\p{Punct}", SEPARATOR);
        if ((value = value.replaceAll("\\.{2,}", SEPARATOR)).endsWith(SEPARATOR)) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

