/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.FilenameUtils;
import org.mule.util.IOUtils;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    private static final Log logger = LogFactory.getLog(FileUtils.class);
    public static String DEFAULT_ENCODING = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void copyStreamToFile(InputStream input, File destination) throws IOException {
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Destination file does not exist or is not writeable");
        }
        try {
            FileOutputStream output = new FileOutputStream(destination);
            try {
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        org.apache.commons.io.FileUtils.cleanDirectory((File)directory);
    }

    public static File createFile(String filename) throws IOException {
        File file = FileUtils.newFile(filename);
        if (!file.canWrite()) {
            String dirName = file.getPath();
            int i = dirName.lastIndexOf(File.separator);
            if (i > -1) {
                dirName = dirName.substring(0, i);
                File dir = FileUtils.newFile(dirName);
                dir.mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }

    public static String prepareWinFilename(String filename) {
        filename = filename.replaceAll("<", "(");
        filename = filename.replaceAll(">", ")");
        filename = filename.replaceAll("[/\\*?|:;\\]\\[\"]", "-");
        return filename;
    }

    public static File openDirectory(String directory) throws IOException {
        File dir = FileUtils.newFile(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new IOException("Path: " + directory + " exists but isn't a directory");
        }
        return dir;
    }

    public static File stringToFile(String filename, String data) throws IOException {
        return FileUtils.stringToFile(filename, data, false);
    }

    public static synchronized File stringToFile(String filename, String data, boolean append) throws IOException {
        return FileUtils.stringToFile(filename, data, append, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized File stringToFile(String filename, String data, boolean append, boolean newLine) throws IOException {
        File f = FileUtils.createFile(filename);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(f, append));
            writer.write(data);
            if (newLine) {
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }

    public static String getResourcePath(String resourceName, Class callingClass) throws IOException {
        return FileUtils.getResourcePath(resourceName, callingClass, DEFAULT_ENCODING);
    }

    public static String getResourcePath(String resourceName, Class callingClass, String encoding) throws IOException {
        if (resourceName == null) {
            return null;
        }
        URL url = IOUtils.getResourceAsUrl(resourceName, callingClass);
        if (url == null) {
            return null;
        }
        return FileUtils.normalizeFilePath(url, encoding);
    }

    public static String normalizeFilePath(URL url, String encoding) throws UnsupportedEncodingException {
        String resource = URLDecoder.decode(url.toExternalForm(), encoding);
        if (resource != null && resource.startsWith("file:/") && !(resource = resource.substring(6)).startsWith(File.separator)) {
            resource = File.separator + resource;
        }
        return resource;
    }

    public static boolean deleteTree(File dir) {
        return FileUtils.deleteTree(dir, null);
    }

    public static boolean deleteTree(File dir, String[] topLevelDirsToIgnore) {
        if (dir == null || !dir.exists()) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            block0: for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (topLevelDirsToIgnore != null) {
                        for (int j = 0; j < topLevelDirsToIgnore.length; ++j) {
                            String ignored = topLevelDirsToIgnore[j];
                            if (ignored.equals(FilenameUtils.getBaseName((String)files[i].getName()))) continue block0;
                        }
                    }
                    if (FileUtils.deleteTree(files[i])) continue;
                    return false;
                }
                if (files[i].delete()) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File archive, File directory) throws IOException {
        ZipFile zip = null;
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("Directory is not a directory: " + directory);
            }
        } else if (!directory.mkdirs()) {
            throw new IOException("Could not create directory: " + directory);
        }
        try {
            zip = new ZipFile(archive);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File f = FileUtils.newFile(directory, entry.getName());
                if (entry.isDirectory()) {
                    if (f.exists() || f.mkdirs()) continue;
                    throw new IOException("Could not create directory: " + f);
                }
                InputStream is = zip.getInputStream(entry);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                IOUtils.copy((InputStream)is, (OutputStream)os);
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    public static File newFile(String pathName) {
        try {
            return new File(pathName).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Unable to create a canonical file for " + pathName), (Throwable)e);
        }
    }

    public static File newFile(URI uri) {
        try {
            return new File(uri).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Unable to create a canonical file for " + uri), (Throwable)e);
        }
    }

    public static File newFile(File parent, String child) {
        try {
            return new File(parent, child).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Unable to create a canonical file for parent: " + parent + " and child: " + child), (Throwable)e);
        }
    }

    public static File newFile(String parent, String child) {
        try {
            return new File(parent, child).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Unable to create a canonical file for parent: " + parent + " and child: " + child), (Throwable)e);
        }
    }

    public static void extractResources(String resourceName, Class callingClass, File outputDir, boolean keepParentDirectory) throws IOException {
        URL url = callingClass.getClassLoader().getResource(resourceName);
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            FileUtils.extractJarResources((JarURLConnection)connection, outputDir, keepParentDirectory);
        } else {
            FileUtils.extractFileResources(FileUtils.normalizeFilePath(url, DEFAULT_ENCODING), outputDir, resourceName, keepParentDirectory);
        }
    }

    private static void extractFileResources(String path, File outputDir, String resourceName, boolean keepParentDirectory) throws IOException {
        File file = FileUtils.newFile(path);
        if (!file.exists()) {
            throw new IOException("The resource by path " + path + " ");
        }
        if (file.isDirectory()) {
            if (keepParentDirectory) {
                if (!(outputDir = FileUtils.newFile(outputDir.getPath() + File.separator + resourceName)).exists()) {
                    outputDir.mkdirs();
                }
            } else {
                outputDir = FileUtils.newFile(outputDir.getPath());
            }
            FileUtils.copyDirectory((File)file, (File)outputDir);
        } else {
            outputDir = keepParentDirectory ? FileUtils.newFile(outputDir.getPath() + File.separator + resourceName) : FileUtils.newFile(outputDir.getPath() + File.separator + file.getName());
            FileUtils.copyFile((File)file, (File)outputDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJarResources(JarURLConnection connection, File outputDir, boolean keepParentDirectory) throws IOException {
        JarFile jarFile = connection.getJarFile();
        JarEntry jarResource = connection.getJarEntry();
        Enumeration<JarEntry> entries = jarFile.entries();
        InputStream inputStream = null;
        BufferedOutputStream outputStream = null;
        int jarResourceNameLenght = jarResource.getName().length();
        while (entries.hasMoreElements()) {
            File file;
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(jarResource.getName())) continue;
            String path = outputDir.getPath() + File.separator + entry.getName();
            if (!keepParentDirectory) {
                if (entry.isDirectory()) {
                    if (entry.getName().equals(jarResource.getName())) continue;
                    path = outputDir.getPath() + File.separator + entry.getName().substring(jarResourceNameLenght, entry.getName().length());
                } else {
                    path = entry.getName().length() > jarResourceNameLenght ? outputDir.getPath() + File.separator + entry.getName().substring(jarResourceNameLenght, entry.getName().length()) : outputDir.getPath() + File.separator + entry.getName().substring(entry.getName().lastIndexOf("/"), entry.getName().length());
                }
            }
            if (!(file = FileUtils.newFile(path)).getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Could not create directory: " + file.getParentFile());
            }
            if (entry.isDirectory()) {
                if (file.exists() || file.mkdirs()) continue;
                throw new IOException("Could not create directory: " + file);
            }
            try {
                inputStream = jarFile.getInputStream(entry);
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public static boolean renameFileHard(String srcFilePath, String destFilePath) {
        if (StringUtils.isNotBlank((String)srcFilePath) && StringUtils.isNotBlank((String)destFilePath)) {
            return FileUtils.renameFileHard(new File(srcFilePath), new File(destFilePath));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameFileHard(File srcFile, File destFile) {
        boolean isRenamed;
        block28: {
            isRenamed = false;
            if (srcFile != null && destFile != null) {
                logger.debug((Object)("Moving file " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath()));
                if (!destFile.exists()) {
                    try {
                        if (srcFile.isFile()) {
                            logger.debug((Object)"Trying to rename file");
                            FileInputStream in = null;
                            FileOutputStream out = null;
                            try {
                                in = new FileInputStream(srcFile);
                                out = new FileOutputStream(destFile);
                                out.getChannel().transferFrom(in.getChannel(), 0L, srcFile.length());
                                isRenamed = true;
                            }
                            catch (Exception e) {
                                logger.debug((Object)e);
                            }
                            finally {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Exception inNotClosed) {
                                        logger.debug((Object)inNotClosed);
                                    }
                                }
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Exception outNotClosed) {
                                        logger.debug((Object)outNotClosed);
                                    }
                                }
                            }
                            logger.debug((Object)("File renamed: " + isRenamed));
                            if (isRenamed) {
                                srcFile.delete();
                            } else {
                                destFile.delete();
                            }
                            break block28;
                        }
                        logger.debug((Object)(srcFile.getAbsolutePath() + " is not a valid file."));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Error renaming file from " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath()));
                    }
                } else {
                    logger.debug((Object)("Error renaming file " + srcFile.getAbsolutePath() + ". Destination file " + destFile.getAbsolutePath() + " already exists."));
                }
            }
        }
        return isRenamed;
    }

    public static boolean renameFile(String srcFilePath, String destFilePath) {
        if (StringUtils.isNotBlank((String)srcFilePath) && StringUtils.isNotBlank((String)destFilePath)) {
            return FileUtils.renameFile(new File(srcFilePath), new File(destFilePath));
        }
        return false;
    }

    public static boolean renameFile(File srcFile, File destFile) {
        boolean isRenamed;
        block8: {
            isRenamed = false;
            if (srcFile != null && destFile != null) {
                logger.debug((Object)("Moving file " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath()));
                if (!destFile.exists()) {
                    try {
                        if (srcFile.isFile()) {
                            logger.debug((Object)"Trying to rename file");
                            isRenamed = srcFile.renameTo(destFile);
                            if (!isRenamed && srcFile.exists()) {
                                logger.debug((Object)"Trying hard copy, assuming partition crossing ...");
                                isRenamed = FileUtils.renameFileHard(srcFile, destFile);
                            }
                            logger.debug((Object)("File renamed: " + isRenamed));
                            break block8;
                        }
                        logger.debug((Object)(srcFile.getAbsolutePath() + " is not a valid file"));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Error moving file from " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath()), (Throwable)e);
                    }
                } else {
                    logger.debug((Object)("Error renaming file " + srcFile.getAbsolutePath() + ". Destination file " + destFile.getAbsolutePath() + " already exists."));
                }
            } else {
                logger.debug((Object)"Error renaming file. Source or destination file is null.");
            }
        }
        return isRenamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFileWithCopyFallback(File sourceFile, File destinationFile) {
        boolean success = sourceFile.renameTo(destinationFile);
        if (!success) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(sourceFile);
                if (!destinationFile.exists()) {
                    FileUtils.createFile(destinationFile.getPath());
                }
                fos = new FileOutputStream(destinationFile);
                FileChannel srcChannel = fis.getChannel();
                FileChannel dstChannel = fos.getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
                success = sourceFile.delete();
            }
            catch (IOException ioex) {
                try {
                    success = false;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
                IOUtils.closeQuietly(fos);
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        return success;
    }

    public static void safeCopyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void copyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
        }
        if (srcFile.isDirectory()) {
            throw new IOException("Source '" + srcFile + "' exists but is a directory");
        }
        if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
            throw new IOException("Source '" + srcFile + "' and destination '" + destFile + "' are the same");
        }
        if (destFile.getParentFile() != null && !destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            throw new IOException("Destination '" + destFile + "' directory cannot be created");
        }
        if (destFile.exists() && !destFile.canWrite()) {
            throw new IOException("Destination '" + destFile + "' exists but is read-only");
        }
        FileUtils.doCopyFile(srcFile, destFile, preserveFileDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileChannel input = new FileInputStream(srcFile).getChannel();
        try {
            FileChannel output = new FileOutputStream(destFile).getChannel();
            try {
                output.transferFrom(input, 0L, input.size());
            }
            finally {
                FileUtils.closeQuietly(output);
            }
        }
        finally {
            FileUtils.closeQuietly(input);
        }
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        if (preserveFileDate) {
            destFile.setLastModified(srcFile.lastModified());
        }
    }

    public static void closeQuietly(Channel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isFile(URL url) {
        return "file".equals(url.getProtocol());
    }

    public static long getFileTimeStamp(URL url) {
        long timeStamp = -1L;
        if (FileUtils.isFile(url)) {
            try {
                String file = URLDecoder.decode(url.getFile(), "UTF-8");
                timeStamp = new File(file).lastModified();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return timeStamp;
    }
}

