/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.watermark.selector;

import org.mule.transport.polling.watermark.selector.WatermarkSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComparableWatermarkSelector
extends WatermarkSelector {
    private static final Logger logger = LoggerFactory.getLogger(ComparableWatermarkSelector.class);

    protected abstract int comparableQualifier();

    @Override
    public final void acceptValue(Object value) {
        if (value == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Received null value. Ignoring", new Object[0]));
            }
        } else if (value instanceof Comparable) {
            Comparable current = (Comparable)this.value;
            if (current == null || ((Comparable)value).compareTo(current) == this.comparableQualifier()) {
                this.value = value;
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug(String.format("This selector only accepts Comparable values but %s found instead. Ignoring.", value.getClass().getCanonicalName()));
        }
    }
}

