/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.stats.ServiceStatistics;
import org.mule.transport.service.TransportFactory;
import org.mule.util.ObjectNameHelper;
import org.mule.util.store.DeserializationPostInitialisable;

public class DefaultReplyToHandler
implements ReplyToHandler,
Serializable,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 1L;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private transient Map<String, ImmutableEndpoint> endpointCache = new HashMap<String, ImmutableEndpoint>();
    protected transient MuleContext muleContext;
    protected transient Connector connector;
    private transient Map<String, Object> serializedData = null;

    public DefaultReplyToHandler(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sending reply to: " + replyTo));
        }
        String replyToEndpoint = replyTo.toString();
        OutboundEndpoint endpoint = this.getEndpoint(event, replyToEndpoint);
        returnMessage.removeProperty("MULE_REPLYTO");
        returnMessage.removeProperty("MULE_REMOTE_SYNC");
        returnMessage = new DefaultMuleMessage(returnMessage.getPayload(), returnMessage, this.muleContext);
        DefaultMuleEvent replyToEvent = new DefaultMuleEvent(returnMessage, event);
        List<String> responseProperties = endpoint.getResponseProperties();
        for (String propertyName : responseProperties) {
            Object propertyValue = event.getMessage().getInboundProperty(propertyName);
            if (propertyValue == null) continue;
            replyToEvent.getMessage().setOutboundProperty(propertyName, propertyValue);
        }
        try {
            ServiceStatistics stats;
            if (event.getFlowConstruct() instanceof Service && (stats = ((Service)event.getFlowConstruct()).getStatistics()).isEnabled()) {
                stats.incSentReplyToEvent();
            }
            endpoint.process(replyToEvent);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("reply to sent: " + endpoint));
            }
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToDispatchToReplyto(endpoint), (MuleEvent)replyToEvent, endpoint, e);
        }
    }

    protected synchronized OutboundEndpoint getEndpoint(MuleEvent event, String endpointUri) throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)this.endpointCache.get(endpointUri);
        if (endpoint == null) {
            EndpointFactory endpointFactory = this.muleContext.getEndpointFactory();
            EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(endpointUri);
            endpoint = endpointFactory.getOutboundEndpoint(endpointBuilder);
            this.endpointCache.put(endpointUri, endpoint);
        }
        return endpoint;
    }

    public void initAfterDeserialisation(MuleContext context) throws MuleException {
        if (this.serializedData == null) {
            return;
        }
        this.muleContext = context;
        this.logger = LogFactory.getLog(this.getClass());
        this.endpointCache = new HashMap<String, ImmutableEndpoint>();
        this.connector = this.findConnector();
        this.serializedData = null;
    }

    public Connector getConnector() {
        return this.connector;
    }

    protected Connector findConnector() {
        String connectorName = (String)this.serializedData.get("connectorName");
        String connectorType = (String)this.serializedData.get("connectorType");
        Connector found = null;
        if (connectorName != null) {
            found = (Connector)this.muleContext.getRegistry().get(connectorName);
        } else if (connectorType != null) {
            found = new TransportFactory(this.muleContext).getDefaultConnectorByProtocol(connectorType);
        }
        return found;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        String connectorName = null;
        String connectorType = null;
        if (this.serializedData != null) {
            connectorName = (String)this.serializedData.get("connectorName");
            connectorType = (String)this.serializedData.get("connectorType");
        } else if (this.connector != null) {
            if (!ObjectNameHelper.isDefaultAutoGeneratedConnector(this.connector)) {
                connectorName = this.connector.getName();
            }
            connectorType = this.connector.getProtocol();
        }
        out.writeObject(connectorName);
        out.writeObject(connectorType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serializedData = new HashMap<String, Object>();
        this.serializedData.put("connectorName", in.readObject());
        this.serializedData.put("connectorType", in.readObject());
    }
}

