/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.config.i18n.MessageFactory;
import org.mule.service.ServiceAsyncReplyCompositeMessageSource;
import org.mule.transport.AbstractTransportMessageHandler;
import org.mule.transport.ConnectableLifecycleManager;

public abstract class AbstractMessageDispatcher
extends AbstractTransportMessageHandler
implements MessageDispatcher {
    protected List<Transformer> defaultOutboundTransformers;
    protected List<Transformer> defaultResponseTransformers;

    public AbstractMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    protected ConnectableLifecycleManager createLifecycleManager() {
        this.defaultOutboundTransformers = this.connector.getDefaultOutboundTransformers(this.endpoint);
        this.defaultResponseTransformers = this.connector.getDefaultResponseTransformers(this.endpoint);
        return new ConnectableLifecycleManager<AbstractMessageDispatcher>(this.getDispatcherName(), this);
    }

    protected String getDispatcherName() {
        return this.getConnector().getName() + ".dispatcher." + System.identityHashCode(this);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            boolean disableTransportTransformer;
            this.connect();
            String prop = (String)event.getMessage().getOutboundProperty("MULE_DISABLE_TRANSPORT_TRANSFORMER");
            boolean bl = disableTransportTransformer = prop != null && Boolean.parseBoolean(prop) || this.endpoint.isDisableTransportTransformer();
            if (!disableTransportTransformer) {
                this.applyOutboundTransformers(event);
            }
            boolean hasResponse = this.endpoint.getExchangePattern().hasResponse();
            this.connector.getSessionHandler().storeSessionInfoToMessage(event.getSession(), event.getMessage());
            if (hasResponse) {
                if (!event.getMuleContext().waitUntilStarted(event.getTimeout())) {
                    throw new MessagingException(MessageFactory.createStaticMessage("Timeout waiting for mule context to be completely started"), event);
                }
                MuleMessage resultMessage = this.doSend(event);
                if (resultMessage != null) {
                    resultMessage.setMessageRootId(event.getMessage().getMessageRootId());
                    resultMessage.setEncoding(resultMessage.getEncoding());
                    MuleSession storedSession = this.connector.getSessionHandler().retrieveSessionInfoFromMessage(resultMessage);
                    event.getSession().merge(storedSession);
                    DefaultMuleEvent resultEvent = new DefaultMuleEvent(resultMessage, event);
                    OptimizedRequestContext.unsafeSetEvent(resultEvent);
                    return resultEvent;
                }
                return null;
            }
            this.doDispatch(event);
            return VoidMuleEvent.getInstance();
        }
        catch (MuleException muleException) {
            throw muleException;
        }
        catch (Exception e) {
            throw new DispatchException(event, this.getEndpoint(), (Throwable)e);
        }
    }

    @Deprecated
    protected boolean returnResponse(MuleEvent event) {
        return this.returnResponse(event, false);
    }

    protected boolean returnResponse(MuleEvent event, boolean doSend) {
        boolean remoteSync = false;
        if (this.endpoint.getConnector().isResponseEnabled()) {
            boolean hasResponse = this.endpoint.getExchangePattern().hasResponse();
            boolean bl = remoteSync = hasResponse || doSend;
            if (remoteSync && event.getFlowConstruct() != null && event.getFlowConstruct() instanceof Service) {
                ServiceAsyncReplyCompositeMessageSource responseRouters = ((Service)event.getFlowConstruct()).getAsyncReplyMessageSource();
                remoteSync = responseRouters == null || responseRouters.getEndpoints().size() <= 0;
            }
        }
        if (!remoteSync) {
            event.getMessage().removeProperty("MULE_REMOTE_SYNC");
        }
        return remoteSync;
    }

    @Override
    protected WorkManager getWorkManager() {
        try {
            return this.connector.getDispatcherWorkManager();
        }
        catch (MuleException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public OutboundEndpoint getEndpoint() {
        return (OutboundEndpoint)super.getEndpoint();
    }

    protected void applyOutboundTransformers(MuleEvent event) throws MuleException {
        event.getMessage().applyTransformers(event, this.defaultOutboundTransformers);
    }

    protected void applyResponseTransformers(MuleEvent event) throws MuleException {
        event.getMessage().applyTransformers(event, this.defaultResponseTransformers);
    }

    protected abstract void doDispatch(MuleEvent var1) throws Exception;

    protected abstract MuleMessage doSend(MuleEvent var1) throws Exception;
}

