/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming;

import java.util.List;
import org.mule.api.MuleException;
import org.mule.streaming.PagingDelegate;
import org.mule.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingDelegateWrapper<T>
extends PagingDelegate<T> {
    private static final Logger logger = LoggerFactory.getLogger(PagingDelegateWrapper.class);
    private PagingDelegate<T> wrapped;
    private boolean closed = false;

    public PagingDelegateWrapper(PagingDelegate<T> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public List<T> getPage() {
        if (this.closed) {
            if (logger.isDebugEnabled()) {
                logger.debug("paging delegate is closed. Returning null");
            }
            return null;
        }
        List<T> page = this.wrapped.getPage();
        if (CollectionUtils.isEmpty(page)) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Empty page was obtained. Closing delegate since this means that the data source has been consumed");
                }
                this.close();
            }
            catch (MuleException e) {
                this.handleCloseException(e);
            }
        }
        return page;
    }

    @Override
    public void close() throws MuleException {
        this.closed = true;
        this.wrapped.close();
    }

    @Override
    public int getTotalResults() {
        return this.wrapped.getTotalResults();
    }

    private void handleCloseException(Throwable t) {
        if (logger.isWarnEnabled()) {
            logger.warn("Exception was found trying to close paging delegate. Execution will continue", t);
        }
    }
}

