/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.SimpleLifecycleManager;

public class DefaultLifecycleManager<T extends Lifecycle>
extends SimpleLifecycleManager<T> {
    public DefaultLifecycleManager(String id, T object) {
        super(id, object);
    }

    @Override
    public void fireInitialisePhase(LifecycleCallback<T> callback) throws InitialisationException {
        this.checkPhase("initialise");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initialising Bean: " + this.lifecycleManagerId));
        }
        try {
            this.invokePhase("initialise", this.getLifecycleObject(), callback);
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (LifecycleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this.object);
        }
    }

    @Override
    public void fireStartPhase(LifecycleCallback<T> callback) throws MuleException {
        this.checkPhase("start");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting Bean: " + this.lifecycleManagerId));
        }
        this.invokePhase("start", this.getLifecycleObject(), callback);
    }

    @Override
    public void fireStopPhase(LifecycleCallback<T> callback) throws MuleException {
        this.checkPhase("stop");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping Bean: " + this.lifecycleManagerId));
        }
        this.invokePhase("stop", this.getLifecycleObject(), callback);
    }

    @Override
    public void fireDisposePhase(LifecycleCallback<T> callback) {
        this.checkPhase("dispose");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposing Bean: " + this.lifecycleManagerId));
        }
        try {
            this.invokePhase("dispose", this.getLifecycleObject(), callback);
        }
        catch (LifecycleException e) {
            this.logger.warn(CoreMessages.failedToDispose(this.lifecycleManagerId), (Throwable)e);
        }
    }
}

