/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.RequiredValueException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.StringUtils;

public class MapPayloadExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "map-payload";

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        Object payload = message.getPayload();
        if (!(payload instanceof Map)) {
            return null;
        }
        if (expression.indexOf(",") > -1) {
            String[] strings = StringUtils.splitAndTrim(expression, ",");
            HashMap<String, Object> result = new HashMap<String, Object>(strings.length);
            for (String s : strings) {
                Object val = this.getValue(s, (Map)payload);
                if (val == null) continue;
                if (s.endsWith("?")) {
                    s = s.substring(0, s.length() - "?".length());
                }
                result.put(s, val);
            }
            return result;
        }
        return this.getValue(expression, (Map)payload);
    }

    protected Object getValue(String key, Map map) {
        boolean required;
        if (key.endsWith("?")) {
            key = key.substring(0, key.length() - "?".length());
            required = false;
        } else {
            required = true;
        }
        Object val = map.get(key);
        if (val != null) {
            return val;
        }
        if (required) {
            throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull(NAME, key));
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

