/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.MessageProcessorPathResolver;
import org.mule.api.processor.MessageProcessor;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.execution.MessageProcessorExecutionInterceptor;

class MessageProcessorNotificationExecutionInterceptor
implements MessageProcessorExecutionInterceptor {
    private MessageProcessorExecutionInterceptor next;

    MessageProcessorNotificationExecutionInterceptor(MessageProcessorExecutionInterceptor next) {
        this.next = next;
    }

    MessageProcessorNotificationExecutionInterceptor() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MuleEvent execute(MessageProcessor messageProcessor, MuleEvent event) throws MessagingException {
        ServerNotificationManager notificationManager = event.getMuleContext().getNotificationManager();
        boolean fireNotification = event.isNotificationsEnabled();
        if (fireNotification) {
            this.fireNotification(notificationManager, event.getFlowConstruct(), event, messageProcessor, null, 1601);
        }
        MuleEvent result = null;
        MessagingException exceptionThrown = null;
        try {
            result = this.next == null ? messageProcessor.process(event) : this.next.execute(messageProcessor, event);
            if (!fireNotification) return result;
            this.fireNotification(notificationManager, event.getFlowConstruct(), result != null ? result : event, messageProcessor, exceptionThrown, 1602);
            return result;
        }
        catch (MessagingException e) {
            try {
                exceptionThrown = e;
                throw e;
                catch (MuleException e2) {
                    exceptionThrown = new MessagingException(event, e2, messageProcessor);
                    throw exceptionThrown;
                }
            }
            catch (Throwable throwable) {
                if (!fireNotification) throw throwable;
                this.fireNotification(notificationManager, event.getFlowConstruct(), result != null ? result : event, messageProcessor, exceptionThrown, 1602);
                throw throwable;
            }
        }
    }

    protected void fireNotification(ServerNotificationManager serverNotificationManager, FlowConstruct flowConstruct, MuleEvent event, MessageProcessor processor, MessagingException exceptionThrown, int action) {
        if (serverNotificationManager != null && serverNotificationManager.isNotificationEnabled(MessageProcessorNotification.class) && flowConstruct instanceof MessageProcessorPathResolver && ((MessageProcessorPathResolver)((Object)flowConstruct)).getProcessorPath(processor) != null) {
            serverNotificationManager.fireNotification(new MessageProcessorNotification(flowConstruct, event, processor, exceptionThrown, action));
        }
    }
}

