/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.URIBuilder;

public class DynamicURIBuilder {
    protected final transient Log logger = LogFactory.getLog(DynamicURIBuilder.class);
    private final URIBuilder templateUriBuilder;

    public DynamicURIBuilder(URIBuilder templateUriBuilder) throws MalformedEndpointException {
        this.validateTemplate(templateUriBuilder.toString());
        this.templateUriBuilder = templateUriBuilder;
    }

    private void validateTemplate(String address) throws MalformedEndpointException {
        if (address.indexOf(":") > address.indexOf("#[")) {
            throw new MalformedEndpointException(CoreMessages.dynamicEndpointsMustSpecifyAScheme(), address);
        }
    }

    public String build(MuleEvent event) throws URISyntaxException, UnsupportedEncodingException {
        String resolvedUri = this.resolveAddress(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Resolved URI from template '%s' to '%s'", this.templateUriBuilder.getEncodedConstructor(), resolvedUri.toString()));
        }
        return resolvedUri;
    }

    private String resolveAddress(MuleEvent event) throws URISyntaxException, UnsupportedEncodingException {
        MuleContext muleContext = this.templateUriBuilder.getMuleContext();
        String resolvedAddress = this.templateUriBuilder.getEncodedConstructor();
        if (muleContext.getExpressionManager().isExpression(resolvedAddress)) {
            resolvedAddress = muleContext.getExpressionManager().parse(resolvedAddress, event, true);
        }
        return resolvedAddress;
    }

    public String getUriTemplate() {
        return this.templateUriBuilder.getAddress();
    }
}

