/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.MessageFactory;
import org.mule.endpoint.EndpointMessageProcessorChainBuilder;
import org.mule.endpoint.inbound.InboundEndpointMimeTypeCheckingMessageProcessor;
import org.mule.endpoint.inbound.InboundEndpointPropertyMessageProcessor;
import org.mule.endpoint.inbound.InboundExceptionDetailsMessageProcessor;
import org.mule.endpoint.inbound.InboundLoggingMessageProcessor;
import org.mule.endpoint.inbound.InboundNotificationMessageProcessor;
import org.mule.endpoint.outbound.OutboundEndpointMimeTypeCheckingMessageProcessor;
import org.mule.endpoint.outbound.OutboundEndpointPropertyMessageProcessor;
import org.mule.endpoint.outbound.OutboundEventTimeoutMessageProcessor;
import org.mule.endpoint.outbound.OutboundLoggingMessageProcessor;
import org.mule.endpoint.outbound.OutboundResponsePropertiesMessageProcessor;
import org.mule.endpoint.outbound.OutboundRewriteResponseEventMessageProcessor;
import org.mule.endpoint.outbound.OutboundRootMessageIdPropertyMessageProcessor;
import org.mule.endpoint.outbound.OutboundSessionHandlerMessageProcessor;
import org.mule.lifecycle.processor.ProcessIfStartedMessageProcessor;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.processor.EndpointTransactionalInterceptingMessageProcessor;
import org.mule.routing.requestreply.ReplyToPropertyRequestReplyReplier;

public class DefaultEndpointMessageProcessorChainFactory
implements EndpointMessageProcessorChainFactory {
    protected List<MessageProcessor> createInboundMessageProcessors(InboundEndpoint endpoint) {
        ArrayList<MessageProcessor> list = new ArrayList<MessageProcessor>();
        list.add(new InboundEndpointMimeTypeCheckingMessageProcessor(endpoint));
        list.add(new InboundEndpointPropertyMessageProcessor(endpoint));
        list.add(new InboundNotificationMessageProcessor(endpoint));
        list.add(new InboundLoggingMessageProcessor(endpoint));
        return list;
    }

    protected List<MessageProcessor> createInboundResponseMessageProcessors(InboundEndpoint endpoint) {
        ArrayList<MessageProcessor> list = new ArrayList<MessageProcessor>();
        list.add(new InboundExceptionDetailsMessageProcessor(endpoint.getConnector()));
        list.add(new ReplyToPropertyRequestReplyReplier());
        return list;
    }

    protected List<MessageProcessor> createOutboundMessageProcessors(OutboundEndpoint endpoint) throws MuleException {
        Connector connector = endpoint.getConnector();
        ArrayList<MessageProcessor> list = new ArrayList<MessageProcessor>();
        list.add(new OutboundLoggingMessageProcessor());
        list.add(new ProcessIfStartedMessageProcessor(connector, connector.getLifecycleState()));
        list.add(new EndpointTransactionalInterceptingMessageProcessor(endpoint.getTransactionConfig()));
        list.add(new OutboundEventTimeoutMessageProcessor());
        list.add(new OutboundSessionHandlerMessageProcessor(connector.getSessionHandler()));
        list.add(new OutboundEndpointPropertyMessageProcessor(endpoint));
        list.add(new OutboundRootMessageIdPropertyMessageProcessor());
        list.add(new OutboundResponsePropertiesMessageProcessor(endpoint));
        list.add(new OutboundEndpointMimeTypeCheckingMessageProcessor(endpoint));
        return list;
    }

    protected List<MessageProcessor> createOutboundResponseMessageProcessors(OutboundEndpoint endpoint) throws MuleException {
        ArrayList<MessageProcessor> list = new ArrayList<MessageProcessor>();
        list.add(new OutboundRewriteResponseEventMessageProcessor());
        return list;
    }

    @Override
    public MessageProcessor createInboundMessageProcessorChain(InboundEndpoint endpoint, FlowConstruct flowConstruct, MessageProcessor target) throws MuleException {
        EndpointMessageProcessorChainBuilder requestChainBuilder = new EndpointMessageProcessorChainBuilder(endpoint, flowConstruct);
        requestChainBuilder.setName("InboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' request chain");
        requestChainBuilder.chain(this.createInboundMessageProcessors(endpoint));
        AbstractRedeliveryPolicy redeliveryPolicy = endpoint.getRedeliveryPolicy();
        if (redeliveryPolicy != null) {
            requestChainBuilder.chain(redeliveryPolicy);
        }
        requestChainBuilder.chain(endpoint.getMessageProcessors());
        if (target == null) {
            throw new ConfigurationException(MessageFactory.createStaticMessage("No listener (target) has been set for this endpoint"));
        }
        requestChainBuilder.chain(target);
        if (!endpoint.getExchangePattern().hasResponse()) {
            return requestChainBuilder.build();
        }
        EndpointMessageProcessorChainBuilder responseChainBuilder = new EndpointMessageProcessorChainBuilder(endpoint, flowConstruct);
        responseChainBuilder.setName("InboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' response chain");
        responseChainBuilder.chain(this.createInboundResponseMessageProcessors(endpoint));
        responseChainBuilder.chain(endpoint.getResponseMessageProcessors());
        EndpointMessageProcessorChainBuilder compositeChainBuilder = new EndpointMessageProcessorChainBuilder(endpoint, flowConstruct);
        compositeChainBuilder.setName("InboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' composite request/response chain");
        compositeChainBuilder.chain(requestChainBuilder.build(), responseChainBuilder.build());
        return compositeChainBuilder.build();
    }

    @Override
    public MessageProcessor createOutboundMessageProcessorChain(OutboundEndpoint endpoint, FlowConstruct flowConstruct, MessageProcessor target) throws MuleException {
        EndpointMessageProcessorChainBuilder requestChainBuilder = new EndpointMessageProcessorChainBuilder(endpoint, flowConstruct);
        requestChainBuilder.setName("OutboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' request chain");
        requestChainBuilder.chain(this.createOutboundMessageProcessors(endpoint));
        requestChainBuilder.chain(endpoint.getMessageProcessors());
        if (target == null) {
            throw new ConfigurationException(MessageFactory.createStaticMessage("No listener (target) has been set for this endpoint"));
        }
        requestChainBuilder.chain(target);
        if (!endpoint.getExchangePattern().hasResponse()) {
            return requestChainBuilder.build();
        }
        EndpointMessageProcessorChainBuilder responseChainBuilder = new EndpointMessageProcessorChainBuilder(endpoint, flowConstruct);
        responseChainBuilder.setName("OutboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' response chain");
        responseChainBuilder.chain(this.createOutboundResponseMessageProcessors(endpoint));
        responseChainBuilder.chain(endpoint.getResponseMessageProcessors());
        EndpointMessageProcessorChainBuilder compositeChainBuilder = new EndpointMessageProcessorChainBuilder(endpoint, flowConstruct);
        compositeChainBuilder.setName("OutboundEndpoint '" + endpoint.getEndpointURI().getUri() + "' composite request/response chain");
        compositeChainBuilder.chain(requestChainBuilder.build(), responseChainBuilder.build());
        return compositeChainBuilder.build();
    }
}

