/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import java.io.Serializable;
import org.apache.commons.collections.map.LRUMap;
import org.mule.api.el.ExpressionExecutor;
import org.mule.api.expression.InvalidExpressionException;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELExpressionExecutor
implements ExpressionExecutor<MVELExpressionLanguageContext> {
    private static Logger log = LoggerFactory.getLogger(MVELExpressionExecutor.class);
    protected static final int COMPILED_EXPRESSION_MAX_CACHE_SIZE = 1000;
    protected ParserContext parserContext;
    protected LRUMap compiledExpressionsCache = new LRUMap(1000);

    public MVELExpressionExecutor(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    @Override
    public Object execute(String expression, MVELExpressionLanguageContext context) {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        if (log.isTraceEnabled()) {
            log.trace("Executing MVEL expression '" + expression + "' with context: \n" + context.toString());
        }
        return MVEL.executeExpression((Object)this.getCompiledExpression(expression), (VariableResolverFactory)context);
    }

    @Override
    public void validate(String expression) throws InvalidExpressionException {
        this.getCompiledExpression(expression);
    }

    protected Serializable getCompiledExpression(String expression) {
        if (this.compiledExpressionsCache.containsKey((Object)expression)) {
            return (Serializable)this.compiledExpressionsCache.get((Object)expression);
        }
        Serializable compiledExpression = MVEL.compileExpression((String)expression, (ParserContext)this.parserContext);
        this.compiledExpressionsCache.put((Object)expression, (Object)compiledExpression);
        return compiledExpression;
    }
}

