/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.mule.el.datetime.DateTime;

public class ServerContext {
    public static String getHost() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static String getIp() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static TimeZone getTimeZone() {
        return Calendar.getInstance().getTimeZone();
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static Map<String, String> getEnv() {
        return System.getenv();
    }

    public static Properties getSystemProperties() {
        return System.getProperties();
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsArch() {
        return System.getProperty("os.arch");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static DateTime getDateTime() {
        return new DateTime();
    }

    public static long nanoTime() {
        return System.nanoTime();
    }
}

