/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorPathElement;

public class DefaultMessageProcessorPathElement
implements MessageProcessorPathElement {
    private MessageProcessorPathElement parent;
    private List<MessageProcessorPathElement> children;
    private MessageProcessor messageProcessor;
    private String name;

    public DefaultMessageProcessorPathElement(MessageProcessor messageProcessor, String name) {
        this.messageProcessor = messageProcessor;
        this.name = name;
        this.children = new ArrayList<MessageProcessorPathElement>();
    }

    @Override
    public MessageProcessorPathElement getParent() {
        return this.parent;
    }

    @Override
    public void setParent(MessageProcessorPathElement parent) {
        this.parent = parent;
    }

    @Override
    public List<MessageProcessorPathElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public MessageProcessorPathElement addChild(MessageProcessor mp) {
        int size = this.children.size();
        DefaultMessageProcessorPathElement result = new DefaultMessageProcessorPathElement(mp, String.valueOf(size));
        this.addChild(result);
        return result;
    }

    @Override
    public MessageProcessorPathElement addChild(String name) {
        DefaultMessageProcessorPathElement result = new DefaultMessageProcessorPathElement(null, name);
        this.addChild(result);
        return result;
    }

    @Override
    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public void addChild(MessageProcessorPathElement mp) {
        this.children.add(mp);
        mp.setParent(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.parent == null ? "/" + this.getName() : this.parent.getPath() + "/" + this.getName();
    }
}

