/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;

public class NotificationUtils {
    private NotificationUtils() {
    }

    public static Map<MessageProcessor, String> buildMessageProcessorPaths(List<MessageProcessor> processors) {
        return NotificationUtils.buildMessageProcessorPaths(processors, null);
    }

    public static Map<MessageProcessor, String> buildMessageProcessorPaths(List<MessageProcessor> processors, String basePath) {
        if (basePath == null) {
            basePath = "/";
        }
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        LinkedHashMap<MessageProcessor, String> result = new LinkedHashMap<MessageProcessor, String>();
        int index = 0;
        for (MessageProcessor mp : processors) {
            String prefix = basePath + index;
            result.put(mp, prefix);
            if (mp instanceof MessageProcessorContainer) {
                Map<MessageProcessor, String> children = ((MessageProcessorContainer)((Object)mp)).getMessageProcessorPaths();
                NotificationUtils.prefixMessageProcessorPaths(prefix, children);
                result.putAll(children);
            }
            ++index;
        }
        return result;
    }

    public static void prefixMessageProcessorPaths(String prefix, Map<MessageProcessor, String> pathMap) {
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        for (Map.Entry<MessageProcessor, String> entry : pathMap.entrySet()) {
            entry.setValue(prefix + entry.getValue());
        }
    }
}

