/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.Pipeline;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.RequestReplyReplierMessageProcessor;
import org.mule.api.transformer.Transformer;
import org.mule.construct.Flow;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.processor.chain.AbstractMessageProcessorChain;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.MessageFilter;

public class DefaultMessageProcessorChain
extends AbstractMessageProcessorChain {
    protected MessageProcessorExecutionTemplate messageProcessorExecutionTemplate = MessageProcessorExecutionTemplate.createExecutionTemplate();

    protected DefaultMessageProcessorChain(List<MessageProcessor> processors) {
        super(null, processors);
    }

    protected DefaultMessageProcessorChain(MessageProcessor ... processors) {
        super(null, new ArrayList<MessageProcessor>(Arrays.asList(processors)));
    }

    protected DefaultMessageProcessorChain(String name, List<MessageProcessor> processors) {
        super(name, processors);
    }

    protected DefaultMessageProcessorChain(String name, MessageProcessor ... processors) {
        super(name, Arrays.asList(processors));
    }

    public static MessageProcessorChain from(MessageProcessor messageProcessor) {
        return new DefaultMessageProcessorChain(messageProcessor);
    }

    public static MessageProcessorChain from(MessageProcessor ... messageProcessors) throws MuleException {
        return new DefaultMessageProcessorChainBuilder().chain(messageProcessors).build();
    }

    public static MessageProcessorChain from(List<MessageProcessor> messageProcessors) throws MuleException {
        return new DefaultMessageProcessorChainBuilder().chain(messageProcessors).build();
    }

    @Override
    protected MuleEvent doProcess(MuleEvent event) throws MuleException {
        if (this.muleContext != null && this.muleContext.getConfiguration().isFlowEndingWithOneWayEndpointReturnsNull()) {
            return this.doProcessFlowEndingWithOneWayEndpointReturnsNull(event);
        }
        FlowConstruct flowConstruct = event.getFlowConstruct();
        MuleEvent copy = null;
        for (int i = 0; i < this.processors.size(); ++i) {
            MessageProcessor processor = (MessageProcessor)this.processors.get(i);
            if (flowConstruct instanceof Flow && this.processorMayReturnNull(processor)) {
                copy = OptimizedRequestContext.criticalSetEvent(event);
            }
            event = this.messageProcessorExecutionTemplate.execute(processor, event);
            if (VoidMuleEvent.getInstance().equals(event)) {
                if (flowConstruct instanceof Pipeline) {
                    event = copy;
                    continue;
                }
                return null;
            }
            if (event != null) continue;
            return null;
        }
        return event;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MuleEvent doProcessFlowEndingWithOneWayEndpointReturnsNull(MuleEvent event) throws MessagingException {
        FlowConstruct flowConstruct = event.getFlowConstruct();
        MuleEvent currentEvent = event;
        MuleEvent copy = null;
        Iterator processorIterator = this.processors.iterator();
        MessageProcessor processor = null;
        if (processorIterator.hasNext()) {
            processor = (MessageProcessor)processorIterator.next();
        }
        boolean resultWasNull = false;
        while (processor != null) {
            MessageProcessor nextProcessor = null;
            if (processorIterator.hasNext()) {
                nextProcessor = (MessageProcessor)processorIterator.next();
            }
            if (flowConstruct instanceof Flow && nextProcessor != null && this.processorMayReturnNull(processor)) {
                copy = OptimizedRequestContext.criticalSetEvent(currentEvent);
            }
            MuleEvent resultEvent = this.messageProcessorExecutionTemplate.execute(processor, currentEvent);
            if (resultWasNull && processor instanceof RequestReplyReplierMessageProcessor) {
                resultEvent = null;
            }
            if (resultEvent != null && !VoidMuleEvent.getInstance().equals(resultEvent)) {
                resultWasNull = false;
                currentEvent = resultEvent;
            } else if (VoidMuleEvent.getInstance().equals(resultEvent)) {
                if (!(flowConstruct instanceof Flow) || nextProcessor == null) return VoidMuleEvent.getInstance();
                resultWasNull = true;
                currentEvent = copy != null ? copy : OptimizedRequestContext.criticalSetEvent(currentEvent);
            } else if (resultEvent == null) {
                return null;
            }
            processor = nextProcessor;
        }
        return currentEvent;
    }

    protected boolean processorMayReturnNull(MessageProcessor processor) {
        if (processor instanceof OutboundEndpoint) {
            MessageExchangePattern exchangePattern = ((OutboundEndpoint)processor).getExchangePattern();
            return exchangePattern == null ? true : !exchangePattern.hasResponse();
        }
        return !(processor instanceof Component) && !(processor instanceof Transformer) && !(processor instanceof MessageFilter);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }
}

