/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message.processing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.message.processing.EndProcessPhase;
import org.mule.message.processing.FlowProcessingPhase;
import org.mule.message.processing.MessageProcessContext;
import org.mule.message.processing.MessageProcessPhase;
import org.mule.message.processing.MessageProcessTemplate;
import org.mule.message.processing.MessageProcessingManager;
import org.mule.message.processing.PhaseExecutionEngine;
import org.mule.message.processing.ValidationPhase;

public class MuleMessageProcessingManager
implements MessageProcessingManager,
MuleContextAware,
Initialisable {
    private final EndProcessPhase endProcessPhase = new EndProcessPhase();
    private MuleContext muleContext;
    private PhaseExecutionEngine phaseExecutionEngine;

    @Override
    public void processMessage(MessageProcessTemplate messageProcessTemplate, MessageProcessContext messageProcessContext) {
        this.phaseExecutionEngine.process(messageProcessTemplate, messageProcessContext);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        Collection<MessageProcessPhase> registryMessageProcessPhases = this.muleContext.getRegistry().lookupObjects(MessageProcessPhase.class);
        ArrayList<MessageProcessPhase> messageProcessPhaseList = new ArrayList<MessageProcessPhase>();
        if (registryMessageProcessPhases != null) {
            messageProcessPhaseList.addAll(registryMessageProcessPhases);
        }
        messageProcessPhaseList.add(new ValidationPhase());
        messageProcessPhaseList.add(new FlowProcessingPhase());
        Collections.sort(messageProcessPhaseList, new Comparator<MessageProcessPhase>(){

            @Override
            public int compare(MessageProcessPhase messageProcessPhase, MessageProcessPhase messageProcessPhase2) {
                int compareValue = 0;
                if (messageProcessPhase instanceof Comparable) {
                    compareValue = ((Comparable)((Object)messageProcessPhase)).compareTo(messageProcessPhase2);
                }
                if (compareValue == 0 && messageProcessPhase2 instanceof Comparable) {
                    compareValue = ((Comparable)((Object)messageProcessPhase2)).compareTo(messageProcessPhase) * -1;
                }
                return compareValue;
            }
        });
        this.phaseExecutionEngine = new PhaseExecutionEngine(messageProcessPhaseList, this.muleContext.getExceptionListener(), this.endProcessPhase);
    }
}

