/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.GlobalNameableObject;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.construct.Pipeline;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.source.ClusterizableMessageSource;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.context.notification.PipelineMessageNotification;
import org.mule.exception.ChoiceMessagingExceptionStrategy;
import org.mule.exception.RollbackMessagingExceptionStrategy;
import org.mule.processor.AbstractFilteringMessageProcessor;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.source.ClusterizableMessageSourceWrapper;
import org.mule.util.NotificationUtils;

public abstract class AbstractPipeline
extends AbstractFlowConstruct
implements Pipeline {
    protected MessageSource messageSource;
    protected MessageProcessor pipeline;
    protected List<MessageProcessor> messageProcessors = Collections.emptyList();
    private Map<MessageProcessor, String> flowMap = new LinkedHashMap<MessageProcessor, String>();
    protected ProcessingStrategy processingStrategy = new SynchronousProcessingStrategy();
    private boolean canProcessMessage = false;

    public AbstractPipeline(String name, MuleContext muleContext) {
        super(name, muleContext);
    }

    protected MessageProcessor createPipeline() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder(this);
        builder.setName("'" + this.getName() + "' processor chain");
        this.configurePreProcessors(builder);
        this.configureMessageProcessors(builder);
        this.configurePostProcessors(builder);
        return builder.build();
    }

    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain(new AbstractInterceptingMessageProcessor(){

            @Override
            public MuleEvent process(MuleEvent event) throws MuleException {
                MuleEvent notificationEvent;
                MuleEvent muleEvent;
                this.muleContext.getNotificationManager().fireNotification(new PipelineMessageNotification(AbstractPipeline.this, event, 1801));
                MuleEvent result = null;
                MessagingException exceptionThrown = null;
                try {
                    muleEvent = this.processNext(event);
                    notificationEvent = result != null ? result : event;
                }
                catch (MessagingException me) {
                    try {
                        exceptionThrown = me;
                        throw me;
                    }
                    catch (Throwable throwable) {
                        MuleEvent notificationEvent2 = result != null ? result : event;
                        this.muleContext.getNotificationManager().fireNotification(new PipelineMessageNotification(AbstractPipeline.this, notificationEvent2, 1804, exceptionThrown));
                        throw throwable;
                    }
                }
                this.muleContext.getNotificationManager().fireNotification(new PipelineMessageNotification(AbstractPipeline.this, notificationEvent, 1804, exceptionThrown));
                return muleEvent;
            }
        });
    }

    protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain(new MessageProcessor(){

            @Override
            public MuleEvent process(MuleEvent event) throws MuleException {
                AbstractPipeline.this.muleContext.getNotificationManager().fireNotification(new PipelineMessageNotification(AbstractPipeline.this, event, 1802));
                return event;
            }
        });
    }

    @Override
    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    @Override
    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource instanceof ClusterizableMessageSource ? new ClusterizableMessageSourceWrapper(this.muleContext, (ClusterizableMessageSource)messageSource, this) : messageSource;
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    public void setProcessingStrategy(ProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    @Override
    protected void doInitialise() throws MuleException {
        super.doInitialise();
        this.pipeline = this.createPipeline();
        if (this.messageSource != null) {
            this.messageSource.setListener(new AbstractInterceptingMessageProcessor(){

                @Override
                public MuleEvent process(MuleEvent event) throws MuleException {
                    return AbstractPipeline.this.pipeline.process(event);
                }
            });
        }
        this.injectFlowConstructMuleContext(this.messageSource);
        this.injectFlowConstructMuleContext(this.pipeline);
        this.initialiseIfInitialisable(this.messageSource);
        this.initialiseIfInitialisable(this.pipeline);
    }

    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        this.getProcessingStrategy().configureProcessors(this.getMessageProcessors(), new ProcessingStrategy.StageNameSource(){

            @Override
            public String getName() {
                return AbstractPipeline.this.getName();
            }
        }, builder, this.muleContext);
    }

    @Override
    protected void validateConstruct() throws FlowConstructInvalidException {
        super.validateConstruct();
        boolean userConfiguredProcessingStrategy = !(this.processingStrategy instanceof DefaultFlowProcessingStrategy);
        boolean userConfiguredAsyncProcessingStrategy = this.processingStrategy instanceof AsynchronousProcessingStrategy && userConfiguredProcessingStrategy;
        boolean redeliveryHandlerConfigured = this.isRedeliveryPolicyConfigured();
        if (userConfiguredAsyncProcessingStrategy && (!this.isMessageSourceCompatibleWithAsync(this.messageSource) || redeliveryHandlerConfigured)) {
            throw new FlowConstructInvalidException(CoreMessages.createStaticMessage("One of the inbound endpoint configured on this Flow is not compatible with an asynchronous processing strategy.  Either because it is request-response, has a transaction defined, or messaging redelivered is configured."), this);
        }
        if (!userConfiguredProcessingStrategy && redeliveryHandlerConfigured) {
            this.setProcessingStrategy(new SynchronousProcessingStrategy());
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Using message redelivery and rollback-exception-strategy requires synchronous processing strategy. Processing strategy re-configured to synchronous");
            }
        }
    }

    protected boolean isRedeliveryPolicyConfigured() {
        boolean isRedeliveredPolicyConfigured = false;
        if (this.exceptionListener instanceof RollbackMessagingExceptionStrategy && ((RollbackMessagingExceptionStrategy)this.exceptionListener).hasMaxRedeliveryAttempts()) {
            isRedeliveredPolicyConfigured = true;
        } else if (this.exceptionListener instanceof ChoiceMessagingExceptionStrategy) {
            ChoiceMessagingExceptionStrategy choiceMessagingExceptionStrategy = (ChoiceMessagingExceptionStrategy)this.exceptionListener;
            for (MessagingExceptionHandlerAcceptor messagingExceptionHandlerAcceptor : choiceMessagingExceptionStrategy.getExceptionListeners()) {
                if (!(messagingExceptionHandlerAcceptor instanceof RollbackMessagingExceptionStrategy)) continue;
                isRedeliveredPolicyConfigured = true;
                break;
            }
        }
        return isRedeliveredPolicyConfigured;
    }

    private boolean isMessageSourceCompatibleWithAsync(MessageSource source) {
        if (source instanceof InboundEndpoint) {
            InboundEndpoint endpoint = (InboundEndpoint)source;
            return !endpoint.getExchangePattern().hasResponse() && !endpoint.getTransactionConfig().isConfigured();
        }
        if (this.messageSource instanceof CompositeMessageSource) {
            for (MessageSource childSource : ((CompositeMessageSource)source).getSources()) {
                if (this.isMessageSourceCompatibleWithAsync(childSource)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        this.startIfStartable(this.pipeline);
        this.canProcessMessage = true;
        this.startIfStartable(this.messageSource);
        this.createFlowMap();
    }

    private void createFlowMap() {
        if (!this.flowMap.isEmpty()) {
            this.logger.warn((Object)"flow map already populated");
            return;
        }
        this.flowMap = this.getMessageProcessorPaths();
    }

    @Override
    public Map<MessageProcessor, String> getMessageProcessorPaths() {
        String prefix = "/" + this.getName() + "/processors";
        Map<MessageProcessor, String> result = NotificationUtils.buildMessageProcessorPaths(this.getMessageProcessors(), prefix);
        if (this.exceptionListener instanceof MessageProcessorContainer) {
            Map<MessageProcessor, String> esPathMap = ((MessageProcessorContainer)((Object)this.exceptionListener)).getMessageProcessorPaths();
            NotificationUtils.prefixMessageProcessorPaths(this.getExceptionStrategyPrefix(), esPathMap);
            result.putAll(esPathMap);
        }
        return result;
    }

    private String getExceptionStrategyPrefix() {
        String esPrefix = "/" + this.getName() + "/es";
        String globalName = null;
        if (this.exceptionListener instanceof GlobalNameableObject) {
            globalName = ((GlobalNameableObject)((Object)this.exceptionListener)).getGlobalName();
        }
        if (globalName != null) {
            esPrefix = "/" + this.getName() + "/" + globalName + "/es";
        }
        return esPrefix;
    }

    @Override
    public String getProcessorPath(MessageProcessor processor) {
        return this.flowMap.get(processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws MuleException {
        try {
            this.stopIfStoppable(this.messageSource);
        }
        finally {
            this.canProcessMessage = false;
        }
        this.stopIfStoppable(this.pipeline);
        super.doStop();
    }

    @Override
    protected void doDispose() {
        this.disposeIfDisposable(this.pipeline);
        this.disposeIfDisposable(this.messageSource);
        super.doDispose();
    }

    public class ProcessIfPipelineStartedMessageProcessor
    extends AbstractFilteringMessageProcessor {
        @Override
        protected boolean accept(MuleEvent event) {
            return AbstractPipeline.this.canProcessMessage;
        }

        @Override
        protected MuleEvent handleUnaccepted(MuleEvent event) throws LifecycleException {
            throw new LifecycleException(CoreMessages.isStopped(AbstractPipeline.this.getName()), (Object)event.getMessage());
        }
    }
}

