/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.pool;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.config.ThreadingProfile;
import org.mule.config.pool.ThreadPoolFactory;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.NamedThreadFactory;
import org.mule.util.concurrent.WaitPolicy;

public class DefaultThreadPoolFactory
extends ThreadPoolFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public ThreadPoolExecutor createPool(String name, ThreadingProfile tp) {
        AbstractQueue buffer = tp.getMaxBufferSize() > 0 && tp.getMaxThreadsActive() > 1 ? new LinkedBlockingDeque(tp.getMaxBufferSize()) : new SynchronousQueue();
        ThreadPoolExecutor pool = this.internalCreatePool(name, tp, (BlockingQueue)((Object)buffer));
        this.configureThreadPoolExecutor(name, tp, pool);
        return pool;
    }

    private void configureThreadPoolExecutor(String name, ThreadingProfile tp, ThreadPoolExecutor pool) {
        this.configureThreadFactory(name, tp, pool);
        if (tp.getRejectedExecutionHandler() != null) {
            pool.setRejectedExecutionHandler(tp.getRejectedExecutionHandler());
        } else {
            switch (tp.getPoolExhaustedAction()) {
                case 2: {
                    pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                    break;
                }
                case 4: {
                    pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                    break;
                }
                case 3: {
                    pool.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                    break;
                }
                case 1: {
                    pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
                    break;
                }
                default: {
                    pool.setRejectedExecutionHandler(new WaitPolicy(tp.getThreadWaitTimeout(), TimeUnit.MILLISECONDS));
                }
            }
        }
    }

    @Override
    public ScheduledThreadPoolExecutor createScheduledPool(String name, ThreadingProfile tp) {
        ScheduledThreadPoolExecutor pool = this.internalCreateScheduledPool(tp);
        this.configureThreadFactory(name, tp, pool);
        return pool;
    }

    protected void configureThreadFactory(String name, ThreadingProfile tp, ThreadPoolExecutor pool) {
        if (tp.getThreadFactory() != null) {
            pool.setThreadFactory(tp.getThreadFactory());
        } else if (StringUtils.isNotBlank((String)name)) {
            pool.setThreadFactory(new NamedThreadFactory(name, Thread.currentThread().getContextClassLoader()));
        }
    }

    protected ThreadPoolExecutor internalCreatePool(String name, ThreadingProfile tp, BlockingQueue buffer) {
        return new ThreadPoolExecutor(Math.min(tp.getMaxThreadsIdle(), tp.getMaxThreadsActive()), tp.getMaxThreadsActive(), tp.getThreadTTL(), TimeUnit.MILLISECONDS, buffer);
    }

    protected ScheduledThreadPoolExecutor internalCreateScheduledPool(ThreadingProfile tp) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(Math.min(tp.getMaxThreadsIdle(), tp.getMaxThreadsActive()));
        scheduledThreadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(true);
        scheduledThreadPoolExecutor.setKeepAliveTime(tp.getThreadTTL(), TimeUnit.MILLISECONDS);
        scheduledThreadPoolExecutor.setCorePoolSize(tp.getMaxThreadsIdle());
        scheduledThreadPoolExecutor.setMaximumPoolSize(tp.getMaxThreadsActive());
        return scheduledThreadPoolExecutor;
    }
}

