/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import org.mule.DynamicDataTypeConversionResolver;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.bootstrap.SimpleRegistryBootstrap;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.endpoint.DefaultEndpointFactory;
import org.mule.message.processing.MuleMessageProcessingManager;
import org.mule.model.seda.SedaModel;
import org.mule.retry.policies.NoRetryPolicyTemplate;
import org.mule.security.MuleSecurityManager;
import org.mule.util.DefaultStreamCloserService;
import org.mule.util.lock.MuleLockFactory;
import org.mule.util.lock.SingleServerLockProvider;
import org.mule.util.queue.TransactionalQueueManager;
import org.mule.util.store.DefaultObjectStoreFactoryBean;
import org.mule.util.store.MuleObjectStoreManager;

public class DefaultsConfigurationBuilder
extends AbstractConfigurationBuilder {
    @Override
    protected void doConfigure(MuleContext muleContext) throws Exception {
        MuleRegistry registry = muleContext.getRegistry();
        registry.registerObject("_muleSimpleRegistryBootstrap", new SimpleRegistryBootstrap());
        this.configureQueueManager(muleContext);
        registry.registerObject("_muleSecurityManager", new MuleSecurityManager());
        registry.registerObject("_defaultInMemoryObjectStore", DefaultObjectStoreFactoryBean.createDefaultInMemoryObjectStore());
        registry.registerObject("_defaultPersistentObjectStore", DefaultObjectStoreFactoryBean.createDefaultPersistentObjectStore());
        registry.registerObject("_defaultInMemoryQueueStore", DefaultObjectStoreFactoryBean.createDefaultInMemoryQueueStore());
        registry.registerObject("_defaultPersistentQueueStore", DefaultObjectStoreFactoryBean.createDefaultPersistentQueueStore());
        registry.registerObject("_defaultUserObjectStore", DefaultObjectStoreFactoryBean.createDefaultUserObjectStore());
        registry.registerObject("_muleObjectStoreManager", new MuleObjectStoreManager());
        registry.registerObject("_muleMessageProcessingManager", new MuleMessageProcessingManager());
        registry.registerObject("_muleEndpointFactory", new DefaultEndpointFactory());
        registry.registerObject("_muleStreamCloserService", new DefaultStreamCloserService());
        registry.registerObject("_muleLockFactory", new MuleLockFactory());
        registry.registerObject("_muleLockProvider", new SingleServerLockProvider());
        this.configureThreadingProfiles(registry);
        registry.registerObject("_defaultRetryPolicyTemplate", new NoRetryPolicyTemplate());
        registry.registerObject("_converterResolver", new DynamicDataTypeConversionResolver(muleContext));
        this.configureSystemModel(registry);
        registry.registerObject("_muleExpressionLanguage", new MVELExpressionLanguage(muleContext));
    }

    protected void configureQueueManager(MuleContext muleContext) throws RegistrationException {
        TransactionalQueueManager queueManager = new TransactionalQueueManager();
        muleContext.getRegistry().registerObject("_muleQueueManager", queueManager);
    }

    protected void configureThreadingProfiles(MuleRegistry registry) throws RegistrationException {
        ChainedThreadingProfile defaultThreadingProfile = new ChainedThreadingProfile();
        registry.registerObject("_defaultThreadingProfile", defaultThreadingProfile);
        registry.registerObject("_defaultMessageReceiverThreadingProfile", new ChainedThreadingProfile(defaultThreadingProfile));
        registry.registerObject("_defaultMessageRequesterThreadingProfile", new ChainedThreadingProfile(defaultThreadingProfile));
        registry.registerObject("_defaultMessageDispatcherThreadingProfile", new ChainedThreadingProfile(defaultThreadingProfile));
        registry.registerObject("_defaultServiceThreadingProfile", new ChainedThreadingProfile(defaultThreadingProfile));
    }

    protected void configureSystemModel(MuleRegistry registry) throws MuleException {
        SedaModel systemModel = new SedaModel();
        systemModel.setName("_muleSystemModel");
        registry.registerModel(systemModel);
    }
}

