/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.queue.QueueKey;

public class PartitionedObjectStoreWrapper<T extends Serializable>
implements ListableObjectStore<T> {
    String partitionName;
    MuleContext context;
    ListableObjectStore<T> baseStore;

    public PartitionedObjectStoreWrapper(String name, MuleContext context, ListableObjectStore<T> store) {
        this.partitionName = name;
        this.context = context;
        this.baseStore = store;
    }

    @Override
    public boolean contains(Serializable key) throws ObjectStoreException {
        return this.getStore().contains(new QueueKey(this.partitionName, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Serializable key, T value) throws ObjectStoreException {
        QueueKey qKey = new QueueKey(this.partitionName, key);
        PartitionedObjectStoreWrapper partitionedObjectStoreWrapper = this;
        synchronized (partitionedObjectStoreWrapper) {
            if (this.getStore().contains(qKey)) {
                throw new ObjectAlreadyExistsException();
            }
            this.getStore().store(qKey, value);
        }
    }

    @Override
    public T retrieve(Serializable key) throws ObjectStoreException {
        return this.getStore().retrieve(new QueueKey(this.partitionName, key));
    }

    @Override
    public T remove(Serializable key) throws ObjectStoreException {
        return this.getStore().remove(new QueueKey(this.partitionName, key));
    }

    @Override
    public boolean isPersistent() {
        return this.getStore().isPersistent();
    }

    @Override
    public void open() throws ObjectStoreException {
        this.getStore().open();
    }

    @Override
    public void close() throws ObjectStoreException {
        this.getStore().close();
    }

    @Override
    public List<Serializable> allKeys() throws ObjectStoreException {
        ArrayList<Serializable> results = new ArrayList<Serializable>();
        List<Serializable> keys = this.getStore().allKeys();
        for (Serializable key : keys) {
            QueueKey qKey = (QueueKey)key;
            if (!qKey.queueName.equals(this.partitionName)) continue;
            results.add(qKey.id);
        }
        return results;
    }

    private ListableObjectStore<T> getStore() {
        return this.baseStore;
    }

    public ListableObjectStore<T> getBaseStore() {
        return this.getStore();
    }
}

