/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.lock;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.util.lock.Lock;

public class ServerLock<T>
implements Lock<T> {
    private Map<T, LockEntry> locks;
    private Object acquireLock = new Object();

    public ServerLock() {
        this.locks = new HashMap<T, LockEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(T key) {
        LockEntry lock;
        Object object = this.acquireLock;
        synchronized (object) {
            if (this.locks.containsKey(key)) {
                lock = this.locks.get(key);
            } else {
                lock = new LockEntry();
                this.locks.put(key, lock);
            }
            lock.incrementLockCount();
            this.acquireLock.notifyAll();
        }
        lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(T key) {
        Object object = this.acquireLock;
        synchronized (object) {
            LockEntry lock = this.locks.get(key);
            if (lock != null) {
                lock.decrementLockCount();
                if (!lock.hasPendingLocks()) {
                    this.locks.remove(key);
                }
                lock.unlock();
            }
            this.acquireLock.notifyAll();
        }
    }

    @Override
    public void dispose() {
        this.locks.clear();
    }

    public static class LockEntry {
        private AtomicInteger lockCount = new AtomicInteger(0);
        private ReentrantLock lock = new ReentrantLock(true);

        public void lock() {
            this.lock.lock();
        }

        public void incrementLockCount() {
            this.lockCount.incrementAndGet();
        }

        public void decrementLockCount() {
            this.lockCount.decrementAndGet();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public boolean hasPendingLocks() {
            return this.lockCount.get() > 0;
        }
    }
}

