/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.ListenerSubscriptionPair;
import org.mule.context.notification.Policy;
import org.mule.context.notification.ServerNotificationManager;

class Configuration {
    protected static Log logger = LogFactory.getLog(Configuration.class);
    private Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> interfaceToTypes = new HashMap<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>>();
    private Set<ListenerSubscriptionPair> listenerSubscriptionPairs = new HashSet<ListenerSubscriptionPair>();
    private Set<Class<? extends ServerNotificationListener>> disabledInterfaces = new HashSet<Class<? extends ServerNotificationListener>>();
    private Set<Class<? extends ServerNotification>> disabledNotificationTypes = new HashSet<Class<? extends ServerNotification>>();
    private volatile boolean dirty = true;
    private Policy policy;

    Configuration() {
    }

    synchronized void addInterfaceToType(Class<? extends ServerNotificationListener> iface, Class<? extends ServerNotification> type) {
        this.dirty = true;
        if (!ServerNotification.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(CoreMessages.propertyIsNotSupportedType("type", ServerNotification.class, type).getMessage());
        }
        if (!this.interfaceToTypes.containsKey(iface)) {
            this.interfaceToTypes.put(iface, new HashSet());
        }
        Set<Class<? extends ServerNotification>> events = this.interfaceToTypes.get(iface);
        events.add(type);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered event type: " + type));
            logger.debug((Object)("Binding listener type '" + iface + "' to event type '" + type + "'"));
        }
    }

    synchronized void addAllInterfaceToTypes(Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> interfaceToTypes) throws ClassNotFoundException {
        this.dirty = true;
        for (Class<? extends ServerNotificationListener> iface : interfaceToTypes.keySet()) {
            this.addInterfaceToType(ServerNotificationManager.toClass(iface), ServerNotificationManager.toClass(interfaceToTypes.get(iface)));
        }
    }

    synchronized void addListenerSubscriptionPair(ListenerSubscriptionPair pair) {
        this.dirty = true;
        if (!this.listenerSubscriptionPairs.add(pair)) {
            logger.warn((Object)CoreMessages.notificationListenerSubscriptionAlreadyRegistered(pair));
        }
    }

    synchronized void addAllListenerSubscriptionPairs(Collection pairs) {
        this.dirty = true;
        Iterator listener = pairs.iterator();
        while (listener.hasNext()) {
            this.addListenerSubscriptionPair((ListenerSubscriptionPair)listener.next());
        }
    }

    synchronized void removeListener(ServerNotificationListener listener) {
        this.dirty = true;
        HashSet<ListenerSubscriptionPair> toRemove = new HashSet<ListenerSubscriptionPair>();
        for (ListenerSubscriptionPair pair : this.listenerSubscriptionPairs) {
            if (!pair.getListener().equals(listener)) continue;
            toRemove.add(pair);
        }
        this.listenerSubscriptionPairs.removeAll(toRemove);
    }

    synchronized void removeAllListeners(Collection listeners) {
        this.dirty = true;
        Iterator listener = listeners.iterator();
        while (listener.hasNext()) {
            this.removeListener((ServerNotificationListener)listener.next());
        }
    }

    synchronized void disableInterface(Class<? extends ServerNotificationListener> iface) {
        this.dirty = true;
        this.disabledInterfaces.add(iface);
    }

    synchronized void disabledAllInterfaces(Collection<Class<? extends ServerNotificationListener>> interfaces) throws ClassNotFoundException {
        this.dirty = true;
        Iterator<Class<? extends ServerNotificationListener>> iface = interfaces.iterator();
        while (iface.hasNext()) {
            this.disableInterface(ServerNotificationManager.toClass(iface.next()));
        }
    }

    synchronized void disableType(Class<? extends ServerNotification> type) {
        this.dirty = true;
        this.disabledNotificationTypes.add(type);
    }

    synchronized void disableAllTypes(Collection types) throws ClassNotFoundException {
        this.dirty = true;
        Iterator event = types.iterator();
        while (event.hasNext()) {
            this.disableType(ServerNotificationManager.toClass(event.next()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Policy getPolicy() {
        if (this.dirty) {
            Configuration configuration = this;
            synchronized (configuration) {
                if (this.dirty) {
                    this.policy = new Policy(this.interfaceToTypes, this.listenerSubscriptionPairs, this.disabledInterfaces, this.disabledNotificationTypes);
                    this.dirty = false;
                }
            }
        }
        return this.policy;
    }

    Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> getInterfaceToTypes() {
        return Collections.unmodifiableMap(this.interfaceToTypes);
    }

    Set<ListenerSubscriptionPair> getListeners() {
        return Collections.unmodifiableSet(this.listenerSubscriptionPairs);
    }
}

