/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.config.ExceptionHelper;
import org.mule.util.ObjectUtils;

public class InboundExceptionDetailsMessageProcessor
implements MessageProcessor {
    private static final Log logger = LogFactory.getLog(InboundExceptionDetailsMessageProcessor.class);
    protected Connector connector;

    public InboundExceptionDetailsMessageProcessor(Connector connector) {
        this.connector = connector;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage resultMessage;
        if (event != null && !VoidMuleEvent.getInstance().equals(event) && (resultMessage = event.getMessage()) != null && resultMessage.getExceptionPayload() != null) {
            this.setExceptionDetails(resultMessage, this.connector, resultMessage.getExceptionPayload().getException());
        }
        return event;
    }

    protected void setExceptionDetails(MuleMessage message, Connector connector, Throwable exception) {
        String propName = ExceptionHelper.getErrorCodePropertyName(connector.getProtocol());
        if (propName != null) {
            String code = ExceptionHelper.getErrorMapping(connector.getProtocol(), exception.getClass());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting error code for: " + connector.getProtocol() + ", " + propName + "=" + code));
            }
            message.setOutboundProperty(propName, code);
        }
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }
}

