/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.component.JavaComponent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.component.BindingInvocationHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.NoSatisfiableMethodsException;
import org.mule.model.resolvers.TooManySatisfiableMethodsException;
import org.mule.util.ClassUtils;

public class BindingUtils {
    public static void configureBinding(JavaComponent component, Object componentObject) throws MuleException {
        if (component.getInterfaceBindings() != null) {
            HashMap bindings = new HashMap();
            for (InterfaceBinding interfaceBinding : component.getInterfaceBindings()) {
                Object proxy = bindings.get(interfaceBinding.getInterface());
                if (proxy == null) {
                    proxy = interfaceBinding.createProxy(componentObject);
                    bindings.put(interfaceBinding.getInterface(), proxy);
                    List<Method> methods = ClassUtils.getSatisfiableMethods(componentObject.getClass(), new Class[]{interfaceBinding.getInterface()}, true, false, null);
                    if (methods.size() != 1) {
                        if (methods.size() > 1) {
                            throw new TooManySatisfiableMethodsException(componentObject.getClass(), new Class[]{interfaceBinding.getInterface()});
                        }
                        throw new NoSatisfiableMethodsException(componentObject.getClass(), new Class[]{interfaceBinding.getInterface()});
                    }
                    Method setterMethod = methods.get(0);
                    try {
                        setterMethod.invoke(componentObject, proxy);
                        continue;
                    }
                    catch (Exception e) {
                        throw new InitialisationException(CoreMessages.failedToSetProxyOnService(interfaceBinding, componentObject.getClass()), (Throwable)e, null);
                    }
                }
                BindingInvocationHandler handler = (BindingInvocationHandler)Proxy.getInvocationHandler(proxy);
                handler.addRouterForInterface(interfaceBinding);
            }
        }
    }
}

