/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.SerializationException;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.util.FileUtils;
import org.mule.util.SerializationUtils;
import org.mule.util.queue.QueueKey;
import org.mule.util.store.AbstractObjectStore;

public class QueuePersistenceObjectStore<T extends Serializable>
extends AbstractObjectStore<T>
implements ListableObjectStore<T>,
MuleContextAware {
    public static final String DEFAULT_QUEUE_STORE = "queuestore";
    private static final String FILE_EXTENSION = ".msg";
    private MuleContext muleContext;
    private File storeDirectory;

    public QueuePersistenceObjectStore() {
    }

    public QueuePersistenceObjectStore(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public void open() throws ObjectStoreException {
        this.initStoreDirectory();
        if (!this.storeDirectory.exists()) {
            this.createStoreDirectory(this.storeDirectory);
        }
    }

    private void initStoreDirectory() throws ObjectStoreException {
        try {
            String workingDirectory = this.muleContext.getConfiguration().getWorkingDirectory();
            String path = workingDirectory + File.separator + DEFAULT_QUEUE_STORE;
            this.storeDirectory = FileUtils.newFile(path);
        }
        catch (MuleRuntimeException mre) {
            throw new ObjectStoreException(mre);
        }
    }

    protected synchronized void createStoreDirectory(File directory) throws ObjectStoreException {
        if (!directory.exists() && !directory.mkdirs()) {
            Message message = CoreMessages.failedToCreate("queue store store directory " + directory.getAbsolutePath());
            throw new ObjectStoreException(message);
        }
    }

    @Override
    public void close() throws ObjectStoreException {
    }

    @Override
    public List<Serializable> allKeys() throws ObjectStoreException {
        if (this.storeDirectory == null) {
            return Collections.emptyList();
        }
        return this.collectAllKeys();
    }

    protected List<Serializable> collectAllKeys() throws ObjectStoreException {
        try {
            ArrayList<Serializable> keys = new ArrayList<Serializable>();
            this.listStoredFiles(this.storeDirectory, keys);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Restore retrieved " + keys.size() + " objects"));
            }
            return keys;
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Could not restore from %1s", this.storeDirectory.getAbsolutePath());
            throw new ObjectStoreException(CoreMessages.createStaticMessage(message));
        }
        catch (IOException e) {
            String message = String.format("Could not restore from %1s", this.storeDirectory.getAbsolutePath());
            throw new ObjectStoreException(CoreMessages.createStaticMessage(message));
        }
    }

    protected void listStoredFiles(File directory, List<Serializable> keys) throws IOException, ClassNotFoundException {
        Object[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            if (((File)files[i]).isDirectory()) {
                this.listStoredFiles((File)files[i], keys);
                continue;
            }
            if (!((File)files[i]).getName().endsWith(FILE_EXTENSION)) continue;
            String id = ((File)files[i]).getCanonicalPath();
            int beginIndex = this.storeDirectory.getCanonicalPath().length() + 1;
            int length = id.length() - FILE_EXTENSION.length();
            id = id.substring(beginIndex, length);
            String queue = id.substring(0, id.indexOf(File.separator));
            id = id.substring(queue.length() + 1);
            keys.add(new QueueKey(queue, (Serializable)((Object)id)));
        }
    }

    @Override
    protected boolean doContains(Serializable key) throws ObjectStoreException {
        File storeFile = this.createStoreFile(key);
        return storeFile.exists();
    }

    @Override
    protected void doStore(Serializable key, T value) throws ObjectStoreException {
        File outputFile = this.createStoreFile(key);
        this.ensureStoreDirectoryExists(outputFile);
        this.serialize(value, outputFile);
    }

    protected void ensureStoreDirectoryExists(File outputFile) throws ObjectStoreException {
        File directory = outputFile.getParentFile();
        if (!directory.exists()) {
            this.createStoreDirectory(directory);
        }
    }

    protected void serialize(T value, File outputFile) throws ObjectStoreException {
        try {
            FileOutputStream out = new FileOutputStream(outputFile);
            SerializationUtils.serialize(value, (OutputStream)out);
        }
        catch (SerializationException se) {
            throw new ObjectStoreException(se);
        }
        catch (FileNotFoundException fnfe) {
            throw new ObjectStoreException(fnfe);
        }
    }

    @Override
    protected T doRetrieve(Serializable key) throws ObjectStoreException {
        File file = this.createStoreFile(key);
        return this.deserialize(file);
    }

    protected File createStoreFile(Serializable key) throws ObjectStoreException {
        QueueKey queueKey = (QueueKey)key;
        String filename = queueKey.id + FILE_EXTENSION;
        String path = queueKey.queueName + File.separator + filename;
        try {
            return FileUtils.newFile(this.storeDirectory, path);
        }
        catch (MuleRuntimeException mre) {
            throw new ObjectStoreException(mre);
        }
    }

    protected T deserialize(File file) throws ObjectStoreException {
        try {
            FileInputStream in = new FileInputStream(file);
            return (T)((Serializable)SerializationUtils.deserialize((InputStream)in, this.muleContext));
        }
        catch (SerializationException se) {
            throw new ObjectStoreException(se);
        }
        catch (FileNotFoundException fnfe) {
            throw new ObjectStoreException(fnfe);
        }
    }

    @Override
    protected T doRemove(Serializable key) throws ObjectStoreException {
        File storeFile = this.createStoreFile(key);
        this.deleteStoreFile(storeFile);
        return null;
    }

    protected void deleteStoreFile(File file) throws ObjectStoreException {
        if (file.exists()) {
            if (!file.delete()) {
                Message message = CoreMessages.createStaticMessage("Deleting " + file.getAbsolutePath() + " failed");
                throw new ObjectStoreException(message);
            }
        } else {
            throw new ObjectDoesNotExistException();
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void removeUnhealthyFiles() throws ObjectStoreException {
        List<Serializable> keys = this.allKeys();
        for (Serializable key : keys) {
            QueueKey qkey = (QueueKey)key;
            String fileName = this.storeDirectory + File.separator + qkey.queueName + File.separator + qkey.id + FILE_EXTENSION;
            File file = new File(fileName);
            if (file.length() != 0L) continue;
            FileUtils.deleteQuietly((File)file);
            this.logger.info((Object)("Removing zero size file: " + file.getAbsolutePath()));
        }
    }
}

