/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;

public class BeanUtils
extends org.apache.commons.beanutils.BeanUtils {
    public static final String SET_PROPERTIES_METHOD = "setProperties";
    private static final Log logger = LogFactory.getLog(BeanUtils.class);

    public static void populateWithoutFail(Object object, Map props, boolean logWarnings) {
        block7: {
            if (ClassUtils.getMethod(object.getClass(), SET_PROPERTIES_METHOD, new Class[]{Map.class}) != null) {
                try {
                    BeanUtils.setProperty((Object)object, (String)"properties", (Object)props);
                }
                catch (Exception e) {
                    if (!logWarnings) break block7;
                    logger.warn((Object)("Property: setProperties=" + Map.class.getName() + " not found on object: " + object.getClass().getName()));
                }
            } else {
                for (Map.Entry entry : props.entrySet()) {
                    try {
                        BeanUtils.setProperty((Object)object, (String)entry.getKey().toString(), entry.getValue());
                    }
                    catch (Exception e) {
                        if (!logWarnings) continue;
                        logger.warn((Object)("Property: " + entry.getKey() + "=" + entry.getValue() + " not found on object: " + object.getClass().getName()));
                    }
                }
            }
        }
    }

    public static void populate(Object bean, Map props) throws IllegalAccessException, InvocationTargetException {
        if (ClassUtils.getMethod(bean.getClass(), SET_PROPERTIES_METHOD, new Class[]{Map.class}) != null) {
            BeanUtils.setProperty((Object)bean, (String)"properties", (Object)props);
        } else {
            Map master = BeanUtils.describe(bean);
            for (Object o : props.keySet()) {
                if (master.containsKey(o)) continue;
                throw new IllegalArgumentException(CoreMessages.propertyDoesNotExistOnObject(o.toString(), bean).getMessage());
            }
            org.apache.commons.beanutils.BeanUtils.populate((Object)bean, (Map)props);
        }
    }

    public static Map describe(Object object) {
        HashMap<String, Object> props = new HashMap<String, Object>(object.getClass().getDeclaredFields().length);
        for (int i = 0; i < object.getClass().getDeclaredFields().length; ++i) {
            Field field = object.getClass().getDeclaredFields()[i];
            field.setAccessible(true);
            try {
                props.put(field.getName(), field.get(object));
                continue;
            }
            catch (IllegalAccessException e) {
                logger.debug((Object)("Unable to read field: " + field.getName() + " on object: " + object));
            }
        }
        return props;
    }

    public static Map<String, Object> describeBean(Object object) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (int i = 0; i < object.getClass().getMethods().length; ++i) {
            Method method = object.getClass().getMethods()[i];
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
            String field = method.getName().startsWith("is") ? method.getName().substring(2) : method.getName().substring(3);
            String setter = "set" + field;
            try {
                object.getClass().getMethod(setter, method.getReturnType());
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)("Ignoring bean property: " + e.getMessage()));
                continue;
            }
            field = field.substring(0, 1).toLowerCase() + field.substring(1);
            try {
                props.put(field, method.invoke(object, new Object[0]));
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)("unable to call bean method: " + method));
            }
        }
        return props;
    }
}

