/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.MessageFactory;
import org.mule.retry.async.AsynchronousRetryTemplate;
import org.mule.retry.policies.SimpleRetryPolicyTemplate;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.util.SystemUtils;

public class UntilSuccessful
extends AbstractOutboundRouter {
    public static final String PROCESS_ATTEMPT_COUNT_PROPERTY_NAME = "process.attempt.count";
    private static final int DEFAULT_PROCESS_ATTEMPT_COUNT_PROPERTY_VALUE = 1;
    private ListableObjectStore<MuleEvent> objectStore;
    private int maxRetries = 5;
    private long secondsBetweenRetries = 60L;
    private String failureExpression;
    private String ackExpression;
    private ExpressionFilter failureExpressionFilter;
    private String eventKeyPrefix;
    private Object deadLetterQueue;
    private MessageProcessor dlqMP;

    @Override
    public void initialise() throws InitialisationException {
        if (this.routes.isEmpty()) {
            throw new InitialisationException(MessageFactory.createStaticMessage("One message processor must be configured within UntilSuccessful."), (Initialisable)this);
        }
        if (this.routes.size() > 1) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Only one message processor is allowed within UntilSuccessful. Use a Processor Chain to group several message processors into one."), (Initialisable)this);
        }
        if (this.objectStore == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("A ListableObjectStore must be configured on UntilSuccessful."), (Initialisable)this);
        }
        super.initialise();
        if (this.deadLetterQueue != null) {
            if (this.deadLetterQueue instanceof EndpointBuilder) {
                try {
                    this.dlqMP = ((EndpointBuilder)this.deadLetterQueue).buildOutboundEndpoint();
                }
                catch (EndpointException ee) {
                    throw new InitialisationException(MessageFactory.createStaticMessage("deadLetterQueue-ref is not a valid endpoint builder: " + this.deadLetterQueue), (Throwable)ee, this);
                }
            } else if (this.deadLetterQueue instanceof MessageProcessor) {
                this.dlqMP = (MessageProcessor)this.deadLetterQueue;
            } else {
                throw new InitialisationException(MessageFactory.createStaticMessage("deadLetterQueue-ref is not a valid mesage processor: " + this.deadLetterQueue), null, this);
            }
        }
        this.failureExpressionFilter = this.failureExpression != null ? new ExpressionFilter(this.failureExpression) : new ExpressionFilter("exception-type:");
        this.failureExpressionFilter.setMuleContext(this.muleContext);
        if (this.ackExpression != null && !this.muleContext.getExpressionManager().isExpression(this.ackExpression)) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Invalid ackExpression: " + this.ackExpression), (Initialisable)this);
        }
        this.eventKeyPrefix = this.flowConstruct.getName() + "@" + this.muleContext.getClusterId() + ":";
    }

    @Override
    public void start() throws MuleException {
        super.start();
        this.scheduleAllPendingEventsForProcessing();
    }

    @Override
    public boolean isMatch(MuleMessage message) throws MuleException {
        return true;
    }

    @Override
    protected MuleEvent route(MuleEvent event) throws MessagingException {
        try {
            this.ensurePayloadSerializable(event);
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage("Failed to prepare message for processing"), event, e, this);
        }
        try {
            EventStoreKey eventStoreKey = this.storeEvent(event);
            this.scheduleForProcessing(eventStoreKey);
            if (this.ackExpression == null) {
                return VoidMuleEvent.getInstance();
            }
            Object ackResponsePayload = this.muleContext.getExpressionManager().evaluate(this.ackExpression, event);
            return new DefaultMuleEvent(new DefaultMuleMessage(ackResponsePayload, event.getMessage(), this.muleContext), event);
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage("Failed to schedule the event for processing"), event, e, this);
        }
    }

    private void scheduleAllPendingEventsForProcessing() throws ObjectStoreException {
        for (Serializable eventStoreKey : this.objectStore.allKeys()) {
            try {
                this.scheduleForProcessing((EventStoreKey)eventStoreKey);
            }
            catch (Exception e) {
                this.logger.error((Object)MessageFactory.createStaticMessage("Failed to schedule for processing event stored with key: " + eventStoreKey), (Throwable)e);
            }
        }
    }

    private void scheduleForProcessing(final EventStoreKey eventStoreKey) throws Exception {
        RetryCallback callback = new RetryCallback(){

            @Override
            public String getWorkDescription() {
                return "Until successful processing of event stored under key: " + eventStoreKey;
            }

            @Override
            public void doWork(RetryContext context) throws Exception {
                UntilSuccessful.this.retrieveAndProcessEvent(eventStoreKey);
            }
        };
        SimpleRetryPolicyTemplate simpleRetryPolicyTemplate = new SimpleRetryPolicyTemplate(TimeUnit.SECONDS.toMillis(this.secondsBetweenRetries), this.maxRetries);
        AsynchronousRetryTemplate retryPolicyTemplate = new AsynchronousRetryTemplate(simpleRetryPolicyTemplate);
        retryPolicyTemplate.setNotifier(new RetryNotifier(){

            @Override
            public void onSuccess(RetryContext context) {
                UntilSuccessful.this.removeFromStore(eventStoreKey);
            }

            @Override
            public void onFailure(RetryContext context, Throwable e) {
                UntilSuccessful.this.incrementProcessAttemptCountOrRemoveFromStore(eventStoreKey);
            }
        });
        retryPolicyTemplate.execute(callback, this.muleContext.getWorkManager());
    }

    private EventStoreKey storeEvent(MuleEvent event) throws ObjectStoreException {
        MuleMessage message = event.getMessage();
        Integer deliveryAttemptCount = message.getInvocationProperty(PROCESS_ATTEMPT_COUNT_PROPERTY_NAME, 1);
        return this.storeEvent(event, deliveryAttemptCount);
    }

    private EventStoreKey storeEvent(MuleEvent event, int deliveryAttemptCount) throws ObjectStoreException {
        MuleMessage message = event.getMessage();
        message.setInvocationProperty(PROCESS_ATTEMPT_COUNT_PROPERTY_NAME, deliveryAttemptCount);
        EventStoreKey eventStoreKey = EventStoreKey.buildFor(event);
        this.objectStore.store(eventStoreKey, event);
        return eventStoreKey;
    }

    private void incrementProcessAttemptCountOrRemoveFromStore(EventStoreKey eventStoreKey) {
        try {
            MuleEvent event = (MuleEvent)this.objectStore.remove(eventStoreKey);
            DefaultMuleEvent mutableEvent = this.threadSafeCopy(event);
            MuleMessage message = mutableEvent.getMessage();
            Integer deliveryAttemptCount = message.getInvocationProperty(PROCESS_ATTEMPT_COUNT_PROPERTY_NAME, 1);
            if (deliveryAttemptCount <= this.getMaxRetries()) {
                message.setInvocationProperty(PROCESS_ATTEMPT_COUNT_PROPERTY_NAME, deliveryAttemptCount + 1);
                this.objectStore.store(eventStoreKey, mutableEvent);
            } else {
                this.abandonRetries(event, mutableEvent);
            }
        }
        catch (ObjectStoreException ose) {
            this.logger.error((Object)("Failed to increment failure count for event stored with key: " + eventStoreKey));
        }
    }

    private void abandonRetries(MuleEvent event, MuleEvent mutableEvent) {
        if (this.dlqMP == null) {
            this.logger.info((Object)("Retry attempts exhausted and no DLQ defined, dropping message: " + event));
            return;
        }
        try {
            this.logger.info((Object)("Retry attempts exhausted, routing message to DLQ: " + this.dlqMP));
            this.dlqMP.process(mutableEvent);
        }
        catch (MuleException me) {
            this.logger.error((Object)("Failed to route message to DLQ: " + this.dlqMP + ", dropping message: " + event), (Throwable)me);
        }
    }

    private void removeFromStore(EventStoreKey eventStoreKey) {
        try {
            this.objectStore.remove(eventStoreKey);
        }
        catch (ObjectStoreException ose) {
            this.logger.warn((Object)("Failed to remove following event from store with key: " + eventStoreKey));
        }
    }

    private void retrieveAndProcessEvent(EventStoreKey eventStoreKey) throws ObjectStoreException {
        MuleEvent persistedEvent = (MuleEvent)this.objectStore.retrieve(eventStoreKey);
        DefaultMuleEvent mutableEvent = this.threadSafeCopy(persistedEvent);
        this.processEvent(mutableEvent);
    }

    private void processEvent(MuleEvent event) {
        MuleEvent returnEvent;
        if (this.routes.isEmpty()) {
            return;
        }
        try {
            returnEvent = ((MessageProcessor)this.routes.get(0)).process(event);
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        if (returnEvent == null || VoidMuleEvent.getInstance().equals(returnEvent)) {
            return;
        }
        MuleMessage msg = returnEvent.getMessage();
        if (msg == null) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("No message found in response to processing, which is therefore considered failed for event: " + event));
        }
        boolean errorDetected = this.failureExpressionFilter.accept(msg);
        if (errorDetected) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Failure expression positive when processing event: " + event));
        }
    }

    private DefaultMuleEvent threadSafeCopy(MuleEvent event) {
        DefaultMuleMessage message = new DefaultMuleMessage(event.getMessage().getPayload(), event.getMessage(), this.muleContext);
        return new DefaultMuleEvent(message, event);
    }

    private void ensurePayloadSerializable(MuleEvent event) throws Exception {
        MuleMessage message = event.getMessage();
        if (message instanceof DefaultMuleMessage) {
            if (((DefaultMuleMessage)message).isConsumable()) {
                message.getPayloadAsBytes();
            }
        } else {
            message.getPayloadAsBytes();
        }
    }

    public ListableObjectStore<MuleEvent> getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ListableObjectStore<MuleEvent> objectStore) {
        this.objectStore = objectStore;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getSecondsBetweenRetries() {
        return this.secondsBetweenRetries;
    }

    public void setSecondsBetweenRetries(long secondsBetweenRetries) {
        this.secondsBetweenRetries = secondsBetweenRetries;
    }

    public String getFailureExpression() {
        return this.failureExpression;
    }

    public void setFailureExpression(String failureExpression) {
        this.failureExpression = failureExpression;
    }

    public String getAckExpression() {
        return this.ackExpression;
    }

    public void setAckExpression(String ackExpression) {
        this.ackExpression = ackExpression;
    }

    public void setDeadLetterQueue(Object deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue;
    }

    public Object getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public String getEventKeyPrefix() {
        return this.eventKeyPrefix;
    }

    public ExpressionFilter getFailureExpressionFilter() {
        return this.failureExpressionFilter;
    }

    public static class EventStoreKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String value;

        private EventStoreKey(String value) {
            this.value = value;
        }

        public static EventStoreKey buildFor(MuleEvent muleEvent) {
            String key = muleEvent.getFlowConstruct() + "@" + muleEvent.getMuleContext().getClusterId() + ":" + muleEvent.getId();
            return new EventStoreKey(SystemUtils.legalizeFileName(key));
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EventStoreKey)) {
                return false;
            }
            return this.value.equals(((EventStoreKey)obj).value);
        }
    }
}

