/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transaction.MuleTransactionConfig;

public class TransactionalInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Initialisable {
    protected MessagingExceptionHandler exceptionListener;
    protected MuleTransactionConfig transactionConfig;

    @Override
    public MuleEvent process(final MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        TransactionalErrorHandlingExecutionTemplate executionTemplate = TransactionalErrorHandlingExecutionTemplate.createScopeExecutionTemplate(this.muleContext, this.transactionConfig, this.exceptionListener);
        ExecutionCallback<MuleEvent> processingCallback = new ExecutionCallback<MuleEvent>(){

            @Override
            public MuleEvent process() throws Exception {
                return TransactionalInterceptingMessageProcessor.this.processNext(event);
            }
        };
        try {
            return executionTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.next, this.transactionConfig), (Throwable)e);
        }
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.exceptionListener == null) {
            this.exceptionListener = this.muleContext.getDefaultExceptionStrategy();
        }
    }

    public void setTransactionConfig(MuleTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }
}

