/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Set;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.el.context.AbstractMapContext;

public class MessagePropertyMapContext
extends AbstractMapContext<String, Object> {
    private MuleMessage message;
    private PropertyScope propertyScope;

    public MessagePropertyMapContext(MuleMessage message, PropertyScope propertyScope) {
        this.message = message;
        this.propertyScope = propertyScope;
    }

    @Override
    public void clear() {
        if (PropertyScope.INBOUND.equals(this.propertyScope)) {
            throw new UnsupportedOperationException(CoreMessages.inboundMessagePropertiesImmutable().getMessage());
        }
        this.message.clearProperties(this.propertyScope);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.message.getPropertyNames(this.propertyScope).contains(key);
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return this.message.getProperty((String)key, this.propertyScope);
    }

    @Override
    public Set<String> keySet() {
        return this.message.getPropertyNames(this.propertyScope);
    }

    @Override
    public Object put(String key, Object value) {
        if (PropertyScope.INBOUND.equals(this.propertyScope)) {
            throw new UnsupportedOperationException(CoreMessages.inboundMessagePropertiesImmutable(key).getMessage());
        }
        Object previousValue = this.get(key);
        this.message.setProperty(key, value, this.propertyScope);
        return previousValue;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        if (PropertyScope.INBOUND.equals(this.propertyScope)) {
            throw new UnsupportedOperationException(CoreMessages.inboundMessagePropertiesImmutable(key).getMessage());
        }
        return this.message.removeProperty((String)key, this.propertyScope);
    }
}

